/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GetUnderlierIDForBasketDefault.class)
public abstract class GetUnderlierIDForBasket
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<String> evaluate(Product product) {
        List<String> basketId = this.doEvaluate(product);
        return basketId;
    }

    protected abstract List<String> doEvaluate(Product var1);

    public static class GetUnderlierIDForBasketDefault
    extends GetUnderlierIDForBasket {
        @Override
        protected List<String> doEvaluate(Product product) {
            ArrayList<String> basketId = new ArrayList<String>();
            return this.assignOutput(basketId, product);
        }

        protected List<String> assignOutput(List<String> basketId, Product product) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getBasket", _product -> _product.getBasket())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                basketId.addAll(MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getBasket", _product -> _product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                basketId.addAll(MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                basketId.addAll(MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                basketId.addAll(MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else {
                basketId.addAll(Collections.emptyList());
            }
            return basketId;
        }
    }
}

