/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GetUnderlierIDForIndexDefault.class)
public abstract class GetUnderlierIDForIndex
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<String> evaluate(Product product) {
        List<String> indexId = this.doEvaluate(product);
        return indexId;
    }

    protected abstract List<String> doEvaluate(Product var1);

    public static class GetUnderlierIDForIndexDefault
    extends GetUnderlierIDForIndex {
        @Override
        protected List<String> doEvaluate(Product product) {
            ArrayList<String> indexId = new ArrayList<String>();
            return this.assignOutput(indexId, product);
        }

        protected List<String> assignOutput(List<String> indexId, Product product) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getIndex", _product -> _product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                indexId.addAll(MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                indexId.addAll(MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                indexId.addAll(MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else {
                indexId.addAll(Collections.emptyList());
            }
            return indexId;
        }
    }
}

