/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.functions;

import cdm.base.staticdata.party.EntityIdentifierTypeEnum;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GetUnderlierLEIForCreditDefault.class)
public abstract class GetUnderlierLEIForCredit
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<String> evaluate(Product product) {
        List<String> lei = this.doEvaluate(product);
        return lei;
    }

    protected abstract List<String> doEvaluate(Product var1);

    public static class GetUnderlierLEIForCreditDefault
    extends GetUnderlierLEIForCredit {
        @Override
        protected List<String> doEvaluate(Product product) {
            ArrayList<String> lei = new ArrayList<String>();
            return this.assignOutput(lei, product);
        }

        protected List<String> assignOutput(List<String> lei, Product product) {
            MapperC thenArg0 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier()) : MapperC.ofNull());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getIdentifierType", entityIdentifier -> entityIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)EntityIdentifierTypeEnum.LEI), (CardinalityOperator)CardinalityOperator.All).get());
            lei.addAll(thenArg1.mapItem(item -> item.map("getIdentifier", entityIdentifier -> entityIdentifier.getIdentifier())).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            return lei;
        }
    }
}

