/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.reports;

import cdm.base.datetime.PeriodEnum;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.FloatingReferencePeriod;
import drr.regulation.common.functions.RateOption;
import drr.standards.iso.FrequencyPeriodEnum;
import javax.inject.Inject;

@ImplementedBy(value=FloatingRateReferencePeriodRuleDefault.class)
public abstract class FloatingRateReferencePeriodRule
implements ReportFunction<InterestRatePayout, FrequencyPeriodEnum> {
    @Inject
    protected FloatingReferencePeriod floatingReferencePeriod;
    @Inject
    protected RateOption rateOption;

    public FrequencyPeriodEnum evaluate(InterestRatePayout input) {
        FrequencyPeriodEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract FrequencyPeriodEnum doEvaluate(InterestRatePayout var1);

    public static class FloatingRateReferencePeriodRuleDefault
    extends FloatingRateReferencePeriodRule {
        @Override
        protected FrequencyPeriodEnum doEvaluate(InterestRatePayout input) {
            FrequencyPeriodEnum output = null;
            return this.assignOutput(output, input);
        }

        protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum output, InterestRatePayout input) {
            MapperS thenArg = MapperS.of((Object)this.rateOption.evaluate(input)).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriod", period -> period.getPeriod());
            output = (FrequencyPeriodEnum)((Object)thenArg.mapSingleToItem(item -> MapperS.of((Object)((Object)this.floatingReferencePeriod.evaluate((PeriodEnum)item.get())))).get());
            return output;
        }
    }
}

