/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.FCAPartyInformation;
import drr.regulation.common.NatureOfPartyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FCAPartyInformationCorporateSector")
@ImplementedBy(value=Default.class)
public interface FCAPartyInformationCorporateSector
extends Validator<FCAPartyInformation> {
    public static final String NAME = "FCAPartyInformationCorporateSector";
    public static final String DEFINITION = "if natureOfParty = Financial or natureOfParty = NonFinancial then corporateSector exists else corporateSector is absent";

    public static class NoOp
    implements FCAPartyInformationCorporateSector {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAPartyInformation fCAPartyInformation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FCAPartyInformationCorporateSector {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAPartyInformation fCAPartyInformation) {
            ComparisonResult result = this.executeDataRule(fCAPartyInformation);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FCAPartyInformationCorporateSector.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FCAPartyInformation", (RosettaPath)path, (String)FCAPartyInformationCorporateSector.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FCAPartyInformationCorporateSector.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FCAPartyInformation", (RosettaPath)path, (String)FCAPartyInformationCorporateSector.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FCAPartyInformation fCAPartyInformation) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)fCAPartyInformation).map("getNatureOfParty", _fCAPartyInformation -> _fCAPartyInformation.getNatureOfParty()), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.FINANCIAL)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)fCAPartyInformation).map("getNatureOfParty", _fCAPartyInformation -> _fCAPartyInformation.getNatureOfParty()), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.NON_FINANCIAL)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)fCAPartyInformation).map("getCorporateSector", _fCAPartyInformation -> _fCAPartyInformation.getCorporateSector()));
                }
                return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)fCAPartyInformation).map("getCorporateSector", _fCAPartyInformation -> _fCAPartyInformation.getCorporateSector()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

