/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsESMAThirdCountryEquivalentMarket;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import drr.standards.iso.MicMarketCategoryEnum;
import drr.standards.iso.functions.GetOrFetchMicData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRMarginReportEMIR_VR_3003_01")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRMarginReportEMIR_VR_3003_01
extends Validator<ESMAEMIRMarginReport> {
    public static final String NAME = "ESMAEMIRMarginReportEMIR_VR_3003_01";
    public static final String DEFINITION = "if (GetOrFetchMicData(nonReportable -> enrichment -> micData, nonReportable -> mic) extract marketCategory = MicMarketCategoryEnum -> RMKT or IsESMAThirdCountryEquivalentMarket(mic)) = False then True else entityResponsibleForReporting is absent";

    public static class NoOp
    implements ESMAEMIRMarginReportEMIR_VR_3003_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRMarginReport eSMAEMIRMarginReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRMarginReportEMIR_VR_3003_01 {
        @Inject
        protected GetOrFetchMicData getOrFetchMicData;
        @Inject
        protected IsESMAThirdCountryEquivalentMarket isESMAThirdCountryEquivalentMarket;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRMarginReport eSMAEMIRMarginReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRMarginReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRMarginReportEMIR_VR_3003_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRMarginReport", (RosettaPath)path, (String)ESMAEMIRMarginReportEMIR_VR_3003_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRMarginReportEMIR_VR_3003_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRMarginReport", (RosettaPath)path, (String)ESMAEMIRMarginReportEMIR_VR_3003_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRMarginReport eSMAEMIRMarginReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.getOrFetchMicData.evaluate(MapperS.of((Object)eSMAEMIRMarginReport).map("getNonReportable", _eSMAEMIRMarginReport -> _eSMAEMIRMarginReport.getNonReportable()).map("getEnrichment", eSMAEMIRNonReportableCollateralData -> eSMAEMIRNonReportableCollateralData.getEnrichment()).mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).getMulti(), (String)MapperS.of((Object)eSMAEMIRMarginReport).map("getNonReportable", _eSMAEMIRMarginReport -> _eSMAEMIRMarginReport.getNonReportable()).map("getMic", eSMAEMIRNonReportableCollateralData -> eSMAEMIRNonReportableCollateralData.getMic()).get())).mapSingleToItem(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getMarketCategory", micData -> micData.getMarketCategory()), (Mapper)MapperS.of((Object)((Object)MicMarketCategoryEnum.RMKT)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isESMAThirdCountryEquivalentMarket.evaluate((String)item.map("getMic", micData -> micData.getMic()).get())))).asMapper()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)true));
                }
                return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)eSMAEMIRMarginReport).map("getEntityResponsibleForReporting", _eSMAEMIRMarginReport -> _eSMAEMIRMarginReport.getEntityResponsibleForReporting()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

