/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.base.util.party.PartyIdentifierFormat2Enum;
import drr.regulation.common.margin.CommonMarginReport;
import drr.regulation.hkma.rewrite.margin.meta.HKMAMarginReportMeta;
import drr.standards.iso.CollateralisationType3Code;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="HKMAMarginReport", builder=HKMAMarginReportBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="HKMAMarginReport", model="drr", builder=HKMAMarginReportBuilderImpl.class, version="7.0.0-dev.101")
public interface HKMAMarginReport
extends CommonMarginReport {
    public static final HKMAMarginReportMeta metaData = new HKMAMarginReportMeta();

    @Override
    public String getCounterparty2();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public ZonedDateTime getEventTimestamp();

    public BigDecimal getNumberRecords();

    public String getTechnicalRecordId();

    public String getCounterparty2Name();

    public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat();

    public Boolean getPortfolioContainingNonReportableComponentIndicator();

    public String getEntityResponsibleForReporting();

    @Override
    public HKMAMarginReport build();

    @Override
    public HKMAMarginReportBuilder toBuilder();

    public static HKMAMarginReportBuilder builder() {
        return new HKMAMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends HKMAMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends HKMAMarginReport> getType() {
        return HKMAMarginReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, (Object)this.getNumberRecords(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportableComponentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class HKMAMarginReportBuilderImpl
    extends CommonMarginReport.CommonMarginReportBuilderImpl
    implements HKMAMarginReportBuilder {
        protected String counterparty2;
        protected Boolean counterparty2IdentifierType;
        protected ZonedDateTime eventTimestamp;
        protected BigDecimal numberRecords;
        protected String technicalRecordId;
        protected String counterparty2Name;
        protected PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        protected Boolean portfolioContainingNonReportableComponentIndicator;
        protected String entityResponsibleForReporting;

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public BigDecimal getNumberRecords() {
            return this.numberRecords;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public Boolean getPortfolioContainingNonReportableComponentIndicator() {
            return this.portfolioContainingNonReportableComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public HKMAMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public HKMAMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public HKMAMarginReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public HKMAMarginReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public HKMAMarginReportBuilder setCounterparty2OverriddenAsString(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public HKMAMarginReportBuilder setCounterparty2(String _counterparty2) {
            return this.setCounterparty2OverriddenAsString(_counterparty2);
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public HKMAMarginReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public HKMAMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public HKMAMarginReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public HKMAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        public HKMAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PreHaircut) {
            this.initialMarginPostedByTheCounterparty1PreHaircut = _initialMarginPostedByTheCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        public HKMAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PostHaircut) {
            this.initialMarginPostedByTheCounterparty1PostHaircut = _initialMarginPostedByTheCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginPostedByCounterparty1Currency")
        public HKMAMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
            this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        public HKMAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PreHaircut) {
            this.variationMarginPostedByTheCounterparty1PreHaircut = _variationMarginPostedByTheCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        public HKMAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PostHaircut) {
            this.variationMarginPostedByTheCounterparty1PostHaircut = _variationMarginPostedByTheCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginPostedByCounterparty1Currency")
        public HKMAMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
            this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        public HKMAMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
            this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        public HKMAMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
            this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1Currency")
        public HKMAMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
            this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        public HKMAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PreHaircut) {
            this.variationMarginCollectedByTheCounterparty1PreHaircut = _variationMarginCollectedByTheCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        public HKMAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PostHaircut) {
            this.variationMarginCollectedByTheCounterparty1PostHaircut = _variationMarginCollectedByTheCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginCollectedByCounterparty1Currency")
        public HKMAMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
            this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralPostedByTheCounterparty1")
        public HKMAMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
            this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public HKMAMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
            this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralCollectedByTheCounterparty1")
        public HKMAMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
            this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public HKMAMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
            this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public HKMAMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public HKMAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public HKMAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public HKMAMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public HKMAMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public HKMAMarginReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public HKMAMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public HKMAMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public HKMAMarginReportBuilder setNumberRecords(BigDecimal _numberRecords) {
            this.numberRecords = _numberRecords == null ? null : _numberRecords;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public HKMAMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public HKMAMarginReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public HKMAMarginReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum _counterparty2IdentifierFormat) {
            this.counterparty2IdentifierFormat = _counterparty2IdentifierFormat == null ? null : _counterparty2IdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public HKMAMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean _portfolioContainingNonReportableComponentIndicator) {
            this.portfolioContainingNonReportableComponentIndicator = _portfolioContainingNonReportableComponentIndicator == null ? null : _portfolioContainingNonReportableComponentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public HKMAMarginReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        public HKMAMarginReport build() {
            return new HKMAMarginReportImpl(this);
        }

        @Override
        public HKMAMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public HKMAMarginReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getNumberRecords() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getCounterparty2Name() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierFormat() != null) {
                return true;
            }
            if (this.getPortfolioContainingNonReportableComponentIndicator() != null) {
                return true;
            }
            return this.getEntityResponsibleForReporting() != null;
        }

        @Override
        public HKMAMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            HKMAMarginReportBuilder o = (HKMAMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2OverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberRecords(), (Object)o.getNumberRecords(), this::setNumberRecords, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2Name(), (Object)o.getCounterparty2Name(), this::setCounterparty2Name, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierFormat(), (Object)o.getCounterparty2IdentifierFormat(), this::setCounterparty2IdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPortfolioContainingNonReportableComponentIndicator(), (Object)o.getPortfolioContainingNonReportableComponentIndicator(), this::setPortfolioContainingNonReportableComponentIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HKMAMarginReport _that = (HKMAMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.numberRecords, _that.getNumberRecords())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) {
                return false;
            }
            return Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.numberRecords != null ? this.numberRecords.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportableComponentIndicator != null ? this.portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "HKMAMarginReportBuilder {counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", numberRecords=" + String.valueOf(this.numberRecords) + ", technicalRecordId=" + this.technicalRecordId + ", counterparty2Name=" + this.counterparty2Name + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + "} " + super.toString();
        }
    }

    public static interface HKMAMarginReportBuilder
    extends HKMAMarginReport,
    CommonMarginReport.CommonMarginReportBuilder {
        @Override
        public HKMAMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public HKMAMarginReportBuilder setCounterparty1(String var1);

        @Override
        public HKMAMarginReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public HKMAMarginReportBuilder setCounterparty2(String var1);

        @Override
        public HKMAMarginReportBuilder setCollateralPortfolioCode(String var1);

        @Override
        public HKMAMarginReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public HKMAMarginReportBuilder setUti(String var1);

        @Override
        public HKMAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code var1);

        @Override
        public HKMAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMAMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMAMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String var1);

        @Override
        public HKMAMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal var1);

        @Override
        public HKMAMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String var1);

        @Override
        public HKMAMarginReportBuilder setCollateralTimestamp(ZonedDateTime var1);

        @Override
        public HKMAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public HKMAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public HKMAMarginReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public HKMAMarginReportBuilder setActionType(MarginActionEnum var1);

        @Override
        public HKMAMarginReportBuilder setEventDate(Date var1);

        @Override
        public HKMAMarginReportBuilder setEventTimestamp(ZonedDateTime var1);

        public HKMAMarginReportBuilder setCounterparty2OverriddenAsString(String var1);

        public HKMAMarginReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public HKMAMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public HKMAMarginReportBuilder setNumberRecords(BigDecimal var1);

        public HKMAMarginReportBuilder setTechnicalRecordId(String var1);

        public HKMAMarginReportBuilder setCounterparty2Name(String var1);

        public HKMAMarginReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum var1);

        public HKMAMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean var1);

        public HKMAMarginReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, (Object)this.getNumberRecords(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportableComponentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public HKMAMarginReportBuilder prune();
    }

    public static class HKMAMarginReportImpl
    extends CommonMarginReport.CommonMarginReportImpl
    implements HKMAMarginReport {
        private final String counterparty2;
        private final Boolean counterparty2IdentifierType;
        private final ZonedDateTime eventTimestamp;
        private final BigDecimal numberRecords;
        private final String technicalRecordId;
        private final String counterparty2Name;
        private final PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        private final Boolean portfolioContainingNonReportableComponentIndicator;
        private final String entityResponsibleForReporting;

        protected HKMAMarginReportImpl(HKMAMarginReportBuilder builder) {
            super(builder);
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.eventTimestamp = builder.getEventTimestamp();
            this.numberRecords = builder.getNumberRecords();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.counterparty2Name = builder.getCounterparty2Name();
            this.counterparty2IdentifierFormat = builder.getCounterparty2IdentifierFormat();
            this.portfolioContainingNonReportableComponentIndicator = builder.getPortfolioContainingNonReportableComponentIndicator();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public BigDecimal getNumberRecords() {
            return this.numberRecords;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public Boolean getPortfolioContainingNonReportableComponentIndicator() {
            return this.portfolioContainingNonReportableComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        public HKMAMarginReport build() {
            return this;
        }

        @Override
        public HKMAMarginReportBuilder toBuilder() {
            HKMAMarginReportBuilder builder = HKMAMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(HKMAMarginReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2OverriddenAsString);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getNumberRecords()).ifPresent(builder::setNumberRecords);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
            Optional.ofNullable(this.getCounterparty2IdentifierFormat()).ifPresent(builder::setCounterparty2IdentifierFormat);
            Optional.ofNullable(this.getPortfolioContainingNonReportableComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportableComponentIndicator);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HKMAMarginReport _that = (HKMAMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.numberRecords, _that.getNumberRecords())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) {
                return false;
            }
            return Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.numberRecords != null ? this.numberRecords.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportableComponentIndicator != null ? this.portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "HKMAMarginReport {counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", numberRecords=" + String.valueOf(this.numberRecords) + ", technicalRecordId=" + this.technicalRecordId + ", counterparty2Name=" + this.counterparty2Name + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + "} " + super.toString();
        }
    }
}

