/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.regulation.hkma.rewrite.trade.reports.PayerIdentifierLeg1Rule;
import drr.regulation.hkma.rewrite.trade.reports.PayerIdentifierLeg2Rule;
import drr.regulation.hkma.rewrite.trade.reports.ReceiverIdentifierLeg1Rule;
import drr.regulation.hkma.rewrite.trade.reports.ReceiverIdentifierLeg2Rule;
import drr.standards.iosco.cde.version3.party.reports.Direction1BuyerIdentifierRule;
import javax.inject.Inject;

@ImplementedBy(value=BuyerIdentifierRuleDefault.class)
public abstract class BuyerIdentifierRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Direction1BuyerIdentifierRule direction1BuyerIdentifierRule;
    @Inject
    protected IsAllowableActionForHKMA isAllowableActionForHKMA;
    @Inject
    protected PayerIdentifierLeg1Rule payerIdentifierLeg1Rule;
    @Inject
    protected PayerIdentifierLeg2Rule payerIdentifierLeg2Rule;
    @Inject
    protected ReceiverIdentifierLeg1Rule receiverIdentifierLeg1Rule;
    @Inject
    protected ReceiverIdentifierLeg2Rule receiverIdentifierLeg2Rule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class BuyerIdentifierRuleDefault
    extends BuyerIdentifierRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForHKMA.evaluate((ReportableEventBase)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)this.payerIdentifierLeg1Rule.evaluate((TransactionReportInstruction)item.get()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)this.payerIdentifierLeg2Rule.evaluate((TransactionReportInstruction)item.get())))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)this.receiverIdentifierLeg1Rule.evaluate((TransactionReportInstruction)item.get())))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)this.receiverIdentifierLeg2Rule.evaluate((TransactionReportInstruction)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.direction1BuyerIdentifierRule.evaluate((TransactionReportInstructionBase)item.get()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

