/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.margin.CommonMarginReport;
import drr.regulation.jfsa.rewrite.margin.meta.JFSAMarginReportMeta;
import drr.standards.iso.CollateralisationType3Code;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="JFSAMarginReport", builder=JFSAMarginReportBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="JFSAMarginReport", model="drr", builder=JFSAMarginReportBuilderImpl.class, version="7.0.0-dev.101")
public interface JFSAMarginReport
extends CommonMarginReport {
    public static final JFSAMarginReportMeta metaData = new JFSAMarginReportMeta();

    @Override
    public ZonedDateTime getEventTimestamp();

    public String getEntityResponsibleForReporting();

    public String getTechnicalRecordId();

    @Override
    public JFSAMarginReport build();

    @Override
    public JFSAMarginReportBuilder toBuilder();

    public static JFSAMarginReportBuilder builder() {
        return new JFSAMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends JFSAMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends JFSAMarginReport> getType() {
        return JFSAMarginReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class JFSAMarginReportBuilderImpl
    extends CommonMarginReport.CommonMarginReportBuilderImpl
    implements JFSAMarginReportBuilder {
        protected ZonedDateTime eventTimestamp;
        protected String entityResponsibleForReporting;
        protected String technicalRecordId;

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public JFSAMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public JFSAMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public JFSAMarginReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public JFSAMarginReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public JFSAMarginReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public JFSAMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public JFSAMarginReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public JFSAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        public JFSAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PreHaircut) {
            this.initialMarginPostedByTheCounterparty1PreHaircut = _initialMarginPostedByTheCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        public JFSAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PostHaircut) {
            this.initialMarginPostedByTheCounterparty1PostHaircut = _initialMarginPostedByTheCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginPostedByCounterparty1Currency")
        public JFSAMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
            this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        public JFSAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PreHaircut) {
            this.variationMarginPostedByTheCounterparty1PreHaircut = _variationMarginPostedByTheCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        public JFSAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PostHaircut) {
            this.variationMarginPostedByTheCounterparty1PostHaircut = _variationMarginPostedByTheCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginPostedByCounterparty1Currency")
        public JFSAMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
            this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        public JFSAMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
            this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        public JFSAMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
            this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1Currency")
        public JFSAMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
            this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        public JFSAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PreHaircut) {
            this.variationMarginCollectedByTheCounterparty1PreHaircut = _variationMarginCollectedByTheCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        public JFSAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PostHaircut) {
            this.variationMarginCollectedByTheCounterparty1PostHaircut = _variationMarginCollectedByTheCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginCollectedByCounterparty1Currency")
        public JFSAMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
            this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralPostedByTheCounterparty1")
        public JFSAMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
            this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public JFSAMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
            this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralCollectedByTheCounterparty1")
        public JFSAMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
            this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public JFSAMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
            this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public JFSAMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public JFSAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public JFSAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public JFSAMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public JFSAMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public JFSAMarginReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public JFSAMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public JFSAMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public JFSAMarginReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public JFSAMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        public JFSAMarginReport build() {
            return new JFSAMarginReportImpl(this);
        }

        @Override
        public JFSAMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public JFSAMarginReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            return this.getTechnicalRecordId() != null;
        }

        @Override
        public JFSAMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            JFSAMarginReportBuilder o = (JFSAMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            JFSAMarginReport _that = (JFSAMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            return Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "JFSAMarginReportBuilder {eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", technicalRecordId=" + this.technicalRecordId + "} " + super.toString();
        }
    }

    public static interface JFSAMarginReportBuilder
    extends JFSAMarginReport,
    CommonMarginReport.CommonMarginReportBuilder {
        @Override
        public JFSAMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public JFSAMarginReportBuilder setCounterparty1(String var1);

        @Override
        public JFSAMarginReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public JFSAMarginReportBuilder setCounterparty2(String var1);

        @Override
        public JFSAMarginReportBuilder setCollateralPortfolioCode(String var1);

        @Override
        public JFSAMarginReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public JFSAMarginReportBuilder setUti(String var1);

        @Override
        public JFSAMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code var1);

        @Override
        public JFSAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public JFSAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public JFSAMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public JFSAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public JFSAMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String var1);

        @Override
        public JFSAMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal var1);

        @Override
        public JFSAMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String var1);

        @Override
        public JFSAMarginReportBuilder setCollateralTimestamp(ZonedDateTime var1);

        @Override
        public JFSAMarginReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public JFSAMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public JFSAMarginReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public JFSAMarginReportBuilder setActionType(MarginActionEnum var1);

        @Override
        public JFSAMarginReportBuilder setEventDate(Date var1);

        @Override
        public JFSAMarginReportBuilder setEventTimestamp(ZonedDateTime var1);

        public JFSAMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public JFSAMarginReportBuilder setEntityResponsibleForReporting(String var1);

        public JFSAMarginReportBuilder setTechnicalRecordId(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public JFSAMarginReportBuilder prune();
    }

    public static class JFSAMarginReportImpl
    extends CommonMarginReport.CommonMarginReportImpl
    implements JFSAMarginReport {
        private final ZonedDateTime eventTimestamp;
        private final String entityResponsibleForReporting;
        private final String technicalRecordId;

        protected JFSAMarginReportImpl(JFSAMarginReportBuilder builder) {
            super(builder);
            this.eventTimestamp = builder.getEventTimestamp();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
            this.technicalRecordId = builder.getTechnicalRecordId();
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        public JFSAMarginReport build() {
            return this;
        }

        @Override
        public JFSAMarginReportBuilder toBuilder() {
            JFSAMarginReportBuilder builder = JFSAMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(JFSAMarginReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            JFSAMarginReport _that = (JFSAMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            return Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "JFSAMarginReport {eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", technicalRecordId=" + this.technicalRecordId + "} " + super.toString();
        }
    }
}

