/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.common.margin.collateral.reports.ActionTypeRule;
import drr.regulation.common.margin.collateral.reports.CollateralPortfolioCodeRule;
import drr.regulation.common.margin.collateral.reports.CollateralPortfolioIndicatorRule;
import drr.regulation.common.margin.collateral.reports.CollateralTimestampRule;
import drr.regulation.common.margin.collateral.reports.CollateralisationCategoryRule;
import drr.regulation.common.margin.collateral.reports.CurrencyOfExcessCollateralCollectedRule;
import drr.regulation.common.margin.collateral.reports.CurrencyOfTheExcessCollateralPostedRule;
import drr.regulation.common.margin.collateral.reports.ExcessCollateralCollectedByTheCounterparty1Rule;
import drr.regulation.common.margin.collateral.reports.ExcessCollateralPostedByTheCounterparty1Rule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollateralPortfolioCodeRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollectedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollectedByCounterparty1PostHaircutRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollectedByCounterparty1PreHaircutRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginPostedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginPostedByTheCounterparty1PostHaircutRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginPostedByTheCounterparty1PreHaircutRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginCollateralPortfolioCodeRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginCollectedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginCollectedByTheCounterparty1PostHaircutRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginCollectedByTheCounterparty1PreHaircutRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginPostedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginPostedByTheCounterparty1PostHaircutRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginPostedByTheCounterparty1PreHaircutRule;
import drr.regulation.common.margin.datetime.reports.EventTimestampRule;
import drr.regulation.common.margin.datetime.reports.ReportingTimestampRule;
import drr.regulation.common.margin.party.reports.Counterparty1Rule;
import drr.regulation.common.margin.party.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.common.margin.party.reports.Counterparty2Rule;
import drr.regulation.common.margin.party.reports.ReportSubmittingEntityIDRule;
import drr.regulation.mas.rewrite.margin.MASMarginReport;
import drr.regulation.mas.rewrite.margin.labels.MASMarginLabelProvider;
import drr.regulation.mas.rewrite.margin.reports.ExecutionAgentOfTheCounterparty1DTCCRule;
import drr.regulation.mas.rewrite.margin.reports.ReportingSpecifiedPersonRule;
import drr.regulation.mas.rewrite.margin.reports.TechnicalRecordIdRule;
import drr.regulation.mas.rewrite.margin.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.mas.rewrite.margin.reports.UniqueTransactionIdentifierRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.mas.rewrite.margin", body="MAS", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=MASMarginLabelProvider.class)
@ImplementedBy(value=MASMarginReportFunctionDefault.class)
public abstract class MASMarginReportFunction
implements ReportFunction<CollateralReportInstruction, MASMarginReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected CollateralPortfolioCodeRule collateralPortfolioCodeRule;
    @Inject
    protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
    @Inject
    protected CollateralTimestampRule collateralTimestampRule;
    @Inject
    protected CollateralisationCategoryRule collateralisationCategoryRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected CurrencyOfExcessCollateralCollectedRule currencyOfExcessCollateralCollectedRule;
    @Inject
    protected CurrencyOfTheExcessCollateralPostedRule currencyOfTheExcessCollateralPostedRule;
    @Inject
    protected EventTimestampRule eventTimestampRule;
    @Inject
    protected ExcessCollateralCollectedByTheCounterparty1Rule excessCollateralCollectedByTheCounterparty1Rule;
    @Inject
    protected ExcessCollateralPostedByTheCounterparty1Rule excessCollateralPostedByTheCounterparty1Rule;
    @Inject
    protected ExecutionAgentOfTheCounterparty1DTCCRule executionAgentOfTheCounterparty1DTCCRule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
    @Inject
    protected InitialMarginCollectedByCounterparty1CurrencyRule initialMarginCollectedByCounterparty1CurrencyRule;
    @Inject
    protected InitialMarginCollectedByCounterparty1PostHaircutRule initialMarginCollectedByCounterparty1PostHaircutRule;
    @Inject
    protected InitialMarginCollectedByCounterparty1PreHaircutRule initialMarginCollectedByCounterparty1PreHaircutRule;
    @Inject
    protected InitialMarginPostedByCounterparty1CurrencyRule initialMarginPostedByCounterparty1CurrencyRule;
    @Inject
    protected InitialMarginPostedByTheCounterparty1PostHaircutRule initialMarginPostedByTheCounterparty1PostHaircutRule;
    @Inject
    protected InitialMarginPostedByTheCounterparty1PreHaircutRule initialMarginPostedByTheCounterparty1PreHaircutRule;
    @Inject
    protected ReportSubmittingEntityIDRule reportSubmittingEntityIDRule;
    @Inject
    protected ReportingSpecifiedPersonRule reportingSpecifiedPersonRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
    @Inject
    protected VariationMarginCollectedByCounterparty1CurrencyRule variationMarginCollectedByCounterparty1CurrencyRule;
    @Inject
    protected VariationMarginCollectedByTheCounterparty1PostHaircutRule variationMarginCollectedByTheCounterparty1PostHaircutRule;
    @Inject
    protected VariationMarginCollectedByTheCounterparty1PreHaircutRule variationMarginCollectedByTheCounterparty1PreHaircutRule;
    @Inject
    protected VariationMarginPostedByCounterparty1CurrencyRule variationMarginPostedByCounterparty1CurrencyRule;
    @Inject
    protected VariationMarginPostedByTheCounterparty1PostHaircutRule variationMarginPostedByTheCounterparty1PostHaircutRule;
    @Inject
    protected VariationMarginPostedByTheCounterparty1PreHaircutRule variationMarginPostedByTheCounterparty1PreHaircutRule;

    public MASMarginReport evaluate(CollateralReportInstruction input) {
        MASMarginReport output;
        MASMarginReport.MASMarginReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(MASMarginReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract MASMarginReport.MASMarginReportBuilder doEvaluate(CollateralReportInstruction var1);

    public static class MASMarginReportFunctionDefault
    extends MASMarginReportFunction {
        @Override
        protected MASMarginReport.MASMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
            MASMarginReport.MASMarginReportBuilder output = MASMarginReport.builder();
            return this.assignOutput(output, input);
        }

        protected MASMarginReport.MASMarginReportBuilder assignOutput(MASMarginReport.MASMarginReportBuilder output, CollateralReportInstruction input) {
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCollateralPortfolioCode(this.collateralPortfolioCodeRule.evaluate(input));
            output.setCollateralPortfolioIndicator(this.collateralPortfolioIndicatorRule.evaluate(input));
            output.setUti(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setCollateralisationCategoryOverriddenAsCollateralisationType3Code(this.collateralisationCategoryRule.evaluate(input));
            output.setInitialMarginPostedByTheCounterparty1PreHaircut(this.initialMarginPostedByTheCounterparty1PreHaircutRule.evaluate(input));
            output.setInitialMarginPostedByTheCounterparty1PostHaircut(this.initialMarginPostedByTheCounterparty1PostHaircutRule.evaluate(input));
            output.setInitialMarginPostedByCounterparty1Currency(this.initialMarginPostedByCounterparty1CurrencyRule.evaluate(input));
            output.setVariationMarginPostedByTheCounterparty1PreHaircut(this.variationMarginPostedByTheCounterparty1PreHaircutRule.evaluate(input));
            output.setVariationMarginPostedByTheCounterparty1PostHaircut(this.variationMarginPostedByTheCounterparty1PostHaircutRule.evaluate(input));
            output.setVariationMarginPostedByCounterparty1Currency(this.variationMarginPostedByCounterparty1CurrencyRule.evaluate(input));
            output.setInitialMarginCollectedByCounterparty1PreHaircut(this.initialMarginCollectedByCounterparty1PreHaircutRule.evaluate(input));
            output.setInitialMarginCollectedByCounterparty1PostHaircut(this.initialMarginCollectedByCounterparty1PostHaircutRule.evaluate(input));
            output.setInitialMarginCollectedByCounterparty1Currency(this.initialMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
            output.setVariationMarginCollectedByTheCounterparty1PreHaircut(this.variationMarginCollectedByTheCounterparty1PreHaircutRule.evaluate(input));
            output.setVariationMarginCollectedByTheCounterparty1PostHaircut(this.variationMarginCollectedByTheCounterparty1PostHaircutRule.evaluate(input));
            output.setVariationMarginCollectedByCounterparty1Currency(this.variationMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
            output.setExcessCollateralPostedByTheCounterparty1(this.excessCollateralPostedByTheCounterparty1Rule.evaluate(input));
            output.setCurrencyOfTheExcessCollateralPosted(this.currencyOfTheExcessCollateralPostedRule.evaluate(input));
            output.setExcessCollateralCollectedByTheCounterparty1(this.excessCollateralCollectedByTheCounterparty1Rule.evaluate(input));
            output.setCurrencyOfTheExcessCollateralCollected(this.currencyOfExcessCollateralCollectedRule.evaluate(input));
            output.setCollateralTimestamp(this.collateralTimestampRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCodeOverriddenAsString(this.variationMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setReportSubmittingEntityID(this.reportSubmittingEntityIDRule.evaluate(input));
            output.setActionTypeOverriddenAsMarginActionEnum(this.actionTypeRule.evaluate(input));
            output.setEventTimestampOverriddenAsZonedDateTime(this.eventTimestampRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setTechnicalRecordId(this.technicalRecordIdRule.evaluate(input));
            output.setExecutionAgentOfTheCounterparty1(this.executionAgentOfTheCounterparty1DTCCRule.evaluate(input));
            output.setReportingSpecifiedPerson(this.reportingSpecifiedPersonRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

