/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.payment.OtherPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.NonReportable;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.mas.rewrite.trade.meta.MASTransactionReportMeta;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MASTransactionReport", builder=MASTransactionReportBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="MASTransactionReport", model="drr", builder=MASTransactionReportBuilderImpl.class, version="7.0.0-dev.101")
public interface MASTransactionReport
extends CommonTransactionReport {
    public static final MASTransactionReportMeta metaData = new MASTransactionReportMeta();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public CommonContractType getContractType();

    @Override
    public CommonAssetClass getAssetClass();

    @Override
    public ClearedEnum getCleared();

    @Override
    public String getVariationMarginCollateralPortfolioCode();

    @Override
    public ZonedDateTime getEventTimestamp();

    @Override
    public String getTechnicalRecordId();

    public String getReportingSpecifiedPerson();

    @Override
    public MASTransactionReport build();

    @Override
    public MASTransactionReportBuilder toBuilder();

    public static MASTransactionReportBuilder builder() {
        return new MASTransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends MASTransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MASTransactionReport> getType() {
        return MASTransactionReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, this.getLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, (Object)this.getReportingSpecifiedPerson(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MASTransactionReportBuilderImpl
    extends CommonTransactionReport.CommonTransactionReportBuilderImpl
    implements MASTransactionReportBuilder {
        protected Boolean counterparty2IdentifierType;
        protected CommonContractType contractType;
        protected CommonAssetClass assetClass;
        protected ClearedEnum cleared;
        protected String variationMarginCollateralPortfolioCode;
        protected ZonedDateTime eventTimestamp;
        protected String technicalRecordId;
        protected String reportingSpecifiedPerson;

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public String getReportingSpecifiedPerson() {
            return this.reportingSpecifiedPerson;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public MASTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public MASTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public MASTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public MASTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public MASTransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public MASTransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public MASTransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public MASTransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public MASTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public MASTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public MASTransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public MASTransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public MASTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setCleared(ClearedEnum _cleared) {
            return this.setClearedOverriddenAsClearedEnum(_cleared);
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public MASTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public MASTransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public MASTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public MASTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public MASTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public MASTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public MASTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public MASTransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public MASTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public MASTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public MASTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public MASTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public MASTransactionReportBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public MASTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public MASTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public MASTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public MASTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public MASTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public MASTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public MASTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public MASTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public MASTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public MASTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public MASTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public MASTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public MASTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public MASTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public MASTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public MASTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public MASTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public MASTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public MASTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public MASTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public MASTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public MASTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public MASTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public MASTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public MASTransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public MASTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public MASTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public MASTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public MASTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public MASTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public MASTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public MASTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public MASTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public MASTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public MASTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public MASTransactionReportBuilder setLeg1(CommonLeg _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setLeg1(Leg _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setLeg1(LegV2 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setLeg1(LegV1 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public MASTransactionReportBuilder setLeg2(CommonLeg _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setLeg2(Leg _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setLeg2(LegV2 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setLeg2(LegV1 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public MASTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public MASTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public MASTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public MASTransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public MASTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public MASTransactionReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MASTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public MASTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public MASTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public MASTransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public MASTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public MASTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public MASTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
            this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public MASTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
            this.traderLocation = _traderLocation == null ? null : _traderLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public MASTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty1")
        @RuneAttribute(value="executionAgentCounterparty1")
        public MASTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
            this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty2")
        @RuneAttribute(value="executionAgentCounterparty2")
        public MASTransactionReportBuilder setExecutionAgentCounterparty2(String _executionAgentCounterparty2) {
            this.executionAgentCounterparty2 = _executionAgentCounterparty2 == null ? null : _executionAgentCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1")
        @RuneAttribute(value="natureOfCounterparty1")
        public MASTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty2")
        @RuneAttribute(value="natureOfCounterparty2")
        public MASTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum _natureOfCounterparty2) {
            this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
            if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
                this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
            return this;
        }

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            if (clearingExceptionsAndExemptionsCounterparty1s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
                    this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public MASTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
            if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
                this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
            return this;
        }

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            if (clearingExceptionsAndExemptionsCounterparty2s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
                    this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public MASTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty1")
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
            if (_corporateSectorOfTheCounterparty1 != null) {
                this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
            return this;
        }

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            if (corporateSectorOfTheCounterparty1s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty1s) {
                    this.corporateSectorOfTheCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public MASTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty2")
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
            if (_corporateSectorOfTheCounterparty2 != null) {
                this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
            }
            return this;
        }

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
            return this;
        }

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            if (corporateSectorOfTheCounterparty2s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty2s) {
                    this.corporateSectorOfTheCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public MASTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public MASTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public MASTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public MASTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterparty2")
        @RuneAttribute(value="countryOfTheCounterparty2")
        public MASTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
            this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public MASTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public MASTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
            this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerID")
        @RuneAttribute(value="brokerID")
        public MASTransactionReportBuilder setBrokerID(String _brokerID) {
            this.brokerID = _brokerID == null ? null : _brokerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public MASTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setContractType(CommonContractType _contractType) {
            return this.setContractTypeOverriddenAsCommonContractType(_contractType);
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public MASTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
            return this.setAssetClassOverriddenAsCommonAssetClass(_assetClass);
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public MASTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public MASTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public MASTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
            this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType")
        @RuneAttribute(value="masterAgreementType")
        public MASTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum _masterAgreementType) {
            this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public MASTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
            this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public MASTransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
            this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public MASTransactionReportBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonStandardizedTermIndicator")
        @RuneAttribute(value="nonStandardizedTermIndicator")
        public MASTransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
            this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="amendmentIndicator")
        @RuneAttribute(value="amendmentIndicator")
        public MASTransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
            this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public MASTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public MASTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public MASTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public MASTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public MASTransactionReportBuilder setSwapLinkID(String _swapLinkID) {
            this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIndicator")
        @RuneAttribute(value="packageIndicator")
        public MASTransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
            this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator")
        @RuneAttribute(value="customBasketIndicator")
        public MASTransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
            this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public MASTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
            this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public MASTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public MASTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
            this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public MASTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
            this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public MASTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public MASTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public MASTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public MASTransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
            this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public MASTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public MASTransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
            this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUSI")
        @RuneAttribute(value="priorUSI")
        public MASTransactionReportBuilder setPriorUSI(String _priorUSI) {
            this.priorUSI = _priorUSI == null ? null : _priorUSI;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public MASTransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public MASTransactionReportBuilder setTechnicalRecordIdOverriddenAsString(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            return this.setTechnicalRecordIdOverriddenAsString(_technicalRecordId);
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public MASTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public MASTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public MASTransactionReportBuilder setSeries(Integer _series) {
            this.series = _series == null ? null : _series;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public MASTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="seriesVersion")
        @RuneAttribute(value="seriesVersion")
        public MASTransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
            this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="baseProduct")
        @RuneAttribute(value="baseProduct")
        public MASTransactionReportBuilder setBaseProduct(String _baseProduct) {
            this.baseProduct = _baseProduct == null ? null : _baseProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="subProduct")
        @RuneAttribute(value="subProduct")
        public MASTransactionReportBuilder setSubProduct(String _subProduct) {
            this.subProduct = _subProduct == null ? null : _subProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="furtherSubProduct")
        @RuneAttribute(value="furtherSubProduct")
        public MASTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
            this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public MASTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public MASTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public MASTransactionReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            return this.setVariationMarginCollateralPortfolioCodeOverriddenAsString(_variationMarginCollateralPortfolioCode);
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public MASTransactionReportBuilder setNonReportable(NonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public MASTransactionReportBuilder setReportingSpecifiedPerson(String _reportingSpecifiedPerson) {
            this.reportingSpecifiedPerson = _reportingSpecifiedPerson == null ? null : _reportingSpecifiedPerson;
            return this;
        }

        @Override
        public MASTransactionReport build() {
            return new MASTransactionReportImpl(this);
        }

        @Override
        public MASTransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public MASTransactionReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            return this.getReportingSpecifiedPerson() != null;
        }

        @Override
        public MASTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MASTransactionReportBuilder o = (MASTransactionReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractTypeOverriddenAsCommonContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClassOverriddenAsCommonAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setClearedOverriddenAsClearedEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCodeOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordIdOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingSpecifiedPerson(), (Object)o.getReportingSpecifiedPerson(), this::setReportingSpecifiedPerson, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MASTransactionReport _that = (MASTransactionReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.reportingSpecifiedPerson, _that.getReportingSpecifiedPerson());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.reportingSpecifiedPerson != null ? this.reportingSpecifiedPerson.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MASTransactionReportBuilder {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", cleared=" + String.valueOf((Object)this.cleared) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", technicalRecordId=" + this.technicalRecordId + ", reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + "} " + super.toString();
        }
    }

    public static interface MASTransactionReportBuilder
    extends MASTransactionReport,
    CommonTransactionReport.CommonTransactionReportBuilder {
        @Override
        public MASTransactionReportBuilder setEffectiveDate(Date var1);

        @Override
        public MASTransactionReportBuilder setEarlyTerminationDate(Date var1);

        @Override
        public MASTransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public MASTransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        @Override
        public MASTransactionReportBuilder setExpirationDate(Date var1);

        @Override
        public MASTransactionReportBuilder setCounterparty1(String var1);

        @Override
        public MASTransactionReportBuilder setCounterparty2(String var1);

        @Override
        public MASTransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public MASTransactionReportBuilder setBeneficiary1(String var1);

        @Override
        public MASTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        @Override
        public MASTransactionReportBuilder setBuyerIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setSellerIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setCleared(ClearedEnum var1);

        @Override
        public MASTransactionReportBuilder setCentralCounterparty(String var1);

        @Override
        public MASTransactionReportBuilder setClearingMember(String var1);

        @Override
        public MASTransactionReportBuilder setConfirmed(ConfirmationEnum var1);

        @Override
        public MASTransactionReportBuilder setCallAmount(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setPutAmount(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setDelta(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder addPriceSchedule(PricePeriod var1);

        @Override
        public MASTransactionReportBuilder addPriceSchedule(PricePeriod var1, int var2);

        @Override
        public MASTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public MASTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public MASTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1);

        @Override
        public MASTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1, int var2);

        @Override
        public MASTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public MASTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public MASTransactionReportBuilder setPrice(PriceFormat var1);

        @Override
        public MASTransactionReportBuilder setPriceNotation(PriceNotationEnum var1);

        @Override
        public MASTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setPackageTransactionPrice(PriceFormat var1);

        @Override
        public MASTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        @Override
        public MASTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setPackageTransactionSpread(PriceFormat var1);

        @Override
        public MASTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        @Override
        public MASTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setPackageIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setStrikePrice(PriceFormat var1);

        @Override
        public MASTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum var1);

        @Override
        public MASTransactionReportBuilder setStrikePriceCurrency(String var1);

        @Override
        public MASTransactionReportBuilder setPriceUnitOfMeasure(String var1);

        @Override
        public MASTransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        @Override
        public MASTransactionReportBuilder setExchangeRate(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setExchangeRateBasis(String var1);

        @Override
        public MASTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public MASTransactionReportBuilder setFirstExerciseDate(Date var1);

        @Override
        public MASTransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public MASTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setPriorUTI(String var1);

        @Override
        public MASTransactionReportBuilder setDirection1(Direction1Enum var1);

        @Override
        public MASTransactionReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public MASTransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public MASTransactionReportBuilder setCustomBasketCode(String var1);

        @Override
        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        @Override
        public MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        @Override
        public MASTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public MASTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public MASTransactionReportBuilder addOtherPayment(OtherPayment var1);

        @Override
        public MASTransactionReportBuilder addOtherPayment(OtherPayment var1, int var2);

        @Override
        public MASTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public MASTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public MASTransactionReportBuilder setLeg1(LegV1 var1);

        @Override
        public MASTransactionReportBuilder setLeg2(LegV1 var1);

        @Override
        public MASTransactionReportBuilder setLeg1(LegV2 var1);

        @Override
        public MASTransactionReportBuilder setLeg2(LegV2 var1);

        @Override
        public MASTransactionReportBuilder setLeg1(Leg var1);

        @Override
        public MASTransactionReportBuilder setLeg2(Leg var1);

        @Override
        public MASTransactionReportBuilder setUnderlyingIdOther(String var1);

        @Override
        public MASTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        @Override
        public MASTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setUnderlyingAssetPriceSource(String var1);

        @Override
        public MASTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        @Override
        public MASTransactionReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public MASTransactionReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public MASTransactionReportBuilder setEventType(EventTypeEnum var1);

        @Override
        public MASTransactionReportBuilder setEventIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        public MASTransactionReportBuilder setLeg1(CommonLeg var1);

        @Override
        public MASTransactionReportBuilder setLeg2(CommonLeg var1);

        @Override
        public MASTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        @Override
        public MASTransactionReportBuilder setPlatformIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setDeliveryType(DeliveryTypeEnum var1);

        @Override
        public MASTransactionReportBuilder setExecutionAgentCounterparty1(String var1);

        @Override
        public MASTransactionReportBuilder setExecutionAgentCounterparty2(String var1);

        @Override
        public MASTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum var1);

        @Override
        public MASTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum var1);

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public MASTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public MASTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public MASTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1);

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1, int var2);

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public MASTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1);

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1, int var2);

        @Override
        public MASTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public MASTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public MASTransactionReportBuilder setCounterparty2Name(String var1);

        @Override
        public MASTransactionReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public MASTransactionReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public MASTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum var1);

        @Override
        public MASTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum var1);

        @Override
        public MASTransactionReportBuilder setTradingCapacity(TradingCapacity7Code var1);

        @Override
        public MASTransactionReportBuilder setBrokerID(String var1);

        @Override
        public MASTransactionReportBuilder setContractType(CommonContractType var1);

        @Override
        public MASTransactionReportBuilder setAssetClass(CommonAssetClass var1);

        @Override
        public MASTransactionReportBuilder setOptionType(OptionTypeCode var1);

        @Override
        public MASTransactionReportBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public MASTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum var1);

        @Override
        public MASTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum var1);

        @Override
        public MASTransactionReportBuilder setMasterAgreementVersion(Integer var1);

        @Override
        public MASTransactionReportBuilder setSecondaryTransactionIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setIntragroup(Boolean var1);

        @Override
        public MASTransactionReportBuilder setNonStandardizedTermIndicator(Boolean var1);

        @Override
        public MASTransactionReportBuilder setAmendmentIndicator(Boolean var1);

        @Override
        public MASTransactionReportBuilder setUnderlyingIdentification(String var1);

        @Override
        public MASTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum var1);

        @Override
        public MASTransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        @Override
        public MASTransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public MASTransactionReportBuilder setSwapLinkID(String var1);

        @Override
        public MASTransactionReportBuilder setPackageIndicator(Boolean var1);

        @Override
        public MASTransactionReportBuilder setCustomBasketIndicator(Boolean var1);

        @Override
        public MASTransactionReportBuilder setPriorUTIProprietary(String var1);

        @Override
        public MASTransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        @Override
        public MASTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum var1);

        @Override
        public MASTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime var1);

        @Override
        public MASTransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public MASTransactionReportBuilder setUniqueProductIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setOriginalSwapUTI(String var1);

        @Override
        public MASTransactionReportBuilder setSubsequentPositionUTI(String var1);

        @Override
        public MASTransactionReportBuilder setOriginalSwapSDRIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setPriorUSI(String var1);

        @Override
        public MASTransactionReportBuilder setNewSDRIdentifier(String var1);

        @Override
        public MASTransactionReportBuilder setTechnicalRecordId(String var1);

        @Override
        public MASTransactionReportBuilder setReferenceEntity(String var1);

        @Override
        public MASTransactionReportBuilder setSeniority(SeniorityEnum var1);

        @Override
        public MASTransactionReportBuilder setSeries(Integer var1);

        @Override
        public MASTransactionReportBuilder setIndexFactor(BigDecimal var1);

        @Override
        public MASTransactionReportBuilder setSeriesVersion(Integer var1);

        @Override
        public MASTransactionReportBuilder setBaseProduct(String var1);

        @Override
        public MASTransactionReportBuilder setSubProduct(String var1);

        @Override
        public MASTransactionReportBuilder setFurtherSubProduct(String var1);

        @Override
        public MASTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier var1);

        @Override
        public MASTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public MASTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public MASTransactionReportBuilder setNonReportable(NonReportable var1);

        public MASTransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public MASTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType var1);

        public MASTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass var1);

        public MASTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum var1);

        public MASTransactionReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String var1);

        public MASTransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public MASTransactionReportBuilder setTechnicalRecordIdOverriddenAsString(String var1);

        public MASTransactionReportBuilder setReportingSpecifiedPerson(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, (RosettaModelObjectBuilder)this.getBarrier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, (RosettaModelObjectBuilder)this.getNonReportable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, (Object)this.getReportingSpecifiedPerson(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MASTransactionReportBuilder prune();
    }

    public static class MASTransactionReportImpl
    extends CommonTransactionReport.CommonTransactionReportImpl
    implements MASTransactionReport {
        private final Boolean counterparty2IdentifierType;
        private final CommonContractType contractType;
        private final CommonAssetClass assetClass;
        private final ClearedEnum cleared;
        private final String variationMarginCollateralPortfolioCode;
        private final ZonedDateTime eventTimestamp;
        private final String technicalRecordId;
        private final String reportingSpecifiedPerson;

        protected MASTransactionReportImpl(MASTransactionReportBuilder builder) {
            super(builder);
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.contractType = builder.getContractType();
            this.assetClass = builder.getAssetClass();
            this.cleared = builder.getCleared();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.eventTimestamp = builder.getEventTimestamp();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.reportingSpecifiedPerson = builder.getReportingSpecifiedPerson();
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public String getReportingSpecifiedPerson() {
            return this.reportingSpecifiedPerson;
        }

        @Override
        public MASTransactionReport build() {
            return this;
        }

        @Override
        public MASTransactionReportBuilder toBuilder() {
            MASTransactionReportBuilder builder = MASTransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MASTransactionReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getContractType()).ifPresent(builder::setContractTypeOverriddenAsCommonContractType);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClassOverriddenAsCommonAssetClass);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setClearedOverriddenAsClearedEnum);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCodeOverriddenAsString);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordIdOverriddenAsString);
            Optional.ofNullable(this.getReportingSpecifiedPerson()).ifPresent(builder::setReportingSpecifiedPerson);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MASTransactionReport _that = (MASTransactionReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.reportingSpecifiedPerson, _that.getReportingSpecifiedPerson());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.reportingSpecifiedPerson != null ? this.reportingSpecifiedPerson.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MASTransactionReport {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", cleared=" + String.valueOf((Object)this.cleared) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", technicalRecordId=" + this.technicalRecordId + ", reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + "} " + super.toString();
        }
    }
}

