/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.trade.payment.functions.PutCurrency_Validationn;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0093_01")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0093_01
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0093_01";
    public static final String DEFINITION = "if contractType = CommonContractType -> OPTN then common.payment.PutCurrency_Validationn( actionType, assetClass, putAmount, putCurrency ) default True and [ISOCurrencyCodeEnum -> XAG, ISOCurrencyCodeEnum -> XAU, ISOCurrencyCodeEnum -> XBA, ISOCurrencyCodeEnum -> XBB, ISOCurrencyCodeEnum -> XBC, ISOCurrencyCodeEnum -> XBD, ISOCurrencyCodeEnum -> XDR, ISOCurrencyCodeEnum -> XPD, ISOCurrencyCodeEnum -> XPT, ISOCurrencyCodeEnum -> XTS] all <> putCurrency";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0093_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0093_01 {
        @Inject
        protected PutCurrency_Validationn putCurrency_Validationn;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0093_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0093_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0093_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0093_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)((Boolean)MapperS.of((Object)this.putCurrency_Validationn.evaluate((ActionTypeEnum)((Object)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()).get()), (CommonAssetClass)((Object)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()).get()), (BigDecimal)MapperS.of((Object)mASTransactionReport).map("getPutAmount", _mASTransactionReport -> _mASTransactionReport.getPutAmount()).get(), (ISOCurrencyCodeEnum)MapperS.of((Object)mASTransactionReport).map("getPutCurrency", _mASTransactionReport -> _mASTransactionReport.getPutCurrency()).get())).getOrDefault((Object)true)))).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)ISOCurrencyCodeEnum.XAG), MapperS.of((Object)ISOCurrencyCodeEnum.XAU), MapperS.of((Object)ISOCurrencyCodeEnum.XBA), MapperS.of((Object)ISOCurrencyCodeEnum.XBB), MapperS.of((Object)ISOCurrencyCodeEnum.XBC), MapperS.of((Object)ISOCurrencyCodeEnum.XBD), MapperS.of((Object)ISOCurrencyCodeEnum.XDR), MapperS.of((Object)ISOCurrencyCodeEnum.XPD), MapperS.of((Object)ISOCurrencyCodeEnum.XPT), MapperS.of((Object)ISOCurrencyCodeEnum.XTS)}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getPutCurrency", _mASTransactionReport -> _mASTransactionReport.getPutCurrency()), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

