/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.sec.rewrite.trade.functions.IsAllowableActionForSEC;
import drr.standards.iosco.uti.functions.GetUniqueTransactionIdentifier;
import java.util.Collections;
import javax.inject.Inject;

@ImplementedBy(value=UTIIDRuleDefault.class)
public abstract class UTIIDRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected GetUniqueTransactionIdentifier getUniqueTransactionIdentifier;
    @Inject
    protected IsAllowableActionForSEC isAllowableActionForSEC;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UTIIDRuleDefault
    extends UTIIDRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForSEC.evaluate((ReportableEventBase)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> {
                SupervisoryBodyEnum supervisoryBodyEnum = SupervisoryBodyEnum.SEC;
                return MapperS.of((Object)this.getUniqueTransactionIdentifier.evaluate((ReportableInformation)item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get(), supervisoryBodyEnum == null ? Collections.emptyList() : Collections.singletonList(supervisoryBodyEnum), null, (TransactionReportInstruction)item.get()));
            }).get();
            return output;
        }
    }
}

