/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.sec.rewrite.trade.functions.IsAllowableActionForSEC;
import drr.standards.iosco.cde.version3.price.reports.PriceUnitOfMeasureRule;
import javax.inject.Inject;

@ImplementedBy(value=UnitsRuleDefault.class)
public abstract class UnitsRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected IsAllowableActionForSEC isAllowableActionForSEC;
    @Inject
    protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UnitsRuleDefault
    extends UnitsRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForSEC.evaluate((ReportableEventBase)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.priceUnitOfMeasureRule.evaluate((TransactionReportInstructionBase)item.get()))).get();
            return output;
        }
    }
}

