/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount")
@ImplementedBy(value=Default.class)
public interface SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount
extends Validator<SECTransactionReport> {
    public static final String NAME = "SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount";
    public static final String DEFINITION = "if dtccAdditionalFields -> primaryAssetClass = InterestRate or nonReportable -> postUpiData -> Header -> AssetClass = Rates then (if leg1 -> fixedRate is absent and postPricedSwapIndicator = False and nonReportable -> instrumentType <> Option and leg1 -> spread is absent then leg2 -> spread exists else leg2 -> spread is absent)";

    public static class NoOp
    implements SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
            ComparisonResult result = this.executeDataRule(sECTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SECTransactionReport", (RosettaPath)path, (String)SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SECTransactionReport", (RosettaPath)path, (String)SECTransactionReportDTCC_SEC_VR_Leg2SpreadAmount.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SECTransactionReport sECTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getDtccAdditionalFields", _sECTransactionReport -> _sECTransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getNonReportable", _sECTransactionReport -> _sECTransactionReport.getNonReportable()).map("getPostUpiData", nonReportable -> nonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.RATES)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).map("getFixedRate", commonLeg -> commonLeg.getFixedRate())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getPostPricedSwapIndicator", _sECTransactionReport -> _sECTransactionReport.getPostPricedSwapIndicator()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getNonReportable", _sECTransactionReport -> _sECTransactionReport.getNonReportable()).map("getInstrumentType", nonReportable -> nonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).map("getSpread", commonLeg -> commonLeg.getSpread()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg2", _sECTransactionReport -> _sECTransactionReport.getLeg2()).map("getSpread", commonLeg -> commonLeg.getSpread()));
                    }
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg2", _sECTransactionReport -> _sECTransactionReport.getLeg2()).map("getSpread", commonLeg -> commonLeg.getSpread()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

