/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SECTransactionReportDTCC_SEC_VR_NotionalAmount1")
@ImplementedBy(value=Default.class)
public interface SECTransactionReportDTCC_SEC_VR_NotionalAmount1
extends Validator<SECTransactionReport> {
    public static final String NAME = "SECTransactionReportDTCC_SEC_VR_NotionalAmount1";
    public static final String DEFINITION = "if leg1 -> notionalCurrency exists and (nonReportable -> postUpiData -> Header -> AssetClass = Foreign_Exchange or dtccAdditionalFields -> primaryAssetClass = ForeignExchange) and [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and (nonReportable -> postUpiData -> Header -> InstrumentType = Option or nonReportable -> instrumentType = Option) then leg1 -> notionalAmount exists and (leg1 -> notionalAmount = callAmount or leg1 -> notionalAmount = putAmount)";

    public static class NoOp
    implements SECTransactionReportDTCC_SEC_VR_NotionalAmount1 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SECTransactionReportDTCC_SEC_VR_NotionalAmount1 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
            ComparisonResult result = this.executeDataRule(sECTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SECTransactionReportDTCC_SEC_VR_NotionalAmount1.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SECTransactionReport", (RosettaPath)path, (String)SECTransactionReportDTCC_SEC_VR_NotionalAmount1.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SECTransactionReportDTCC_SEC_VR_NotionalAmount1.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SECTransactionReport", (RosettaPath)path, (String)SECTransactionReportDTCC_SEC_VR_NotionalAmount1.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SECTransactionReport sECTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getNonReportable", _sECTransactionReport -> _sECTransactionReport.getNonReportable()).map("getPostUpiData", nonReportable -> nonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getDtccAdditionalFields", _sECTransactionReport -> _sECTransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.FOREIGN_EXCHANGE), (CardinalityOperator)CardinalityOperator.All))).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)sECTransactionReport).map("getActionType", _sECTransactionReport -> _sECTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getNonReportable", _sECTransactionReport -> _sECTransactionReport.getNonReportable()).map("getPostUpiData", nonReportable -> nonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getNonReportable", _sECTransactionReport -> _sECTransactionReport.getNonReportable()).map("getInstrumentType", nonReportable -> nonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)sECTransactionReport).map("getCallAmount", _sECTransactionReport -> _sECTransactionReport.getCallAmount()), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg1", _sECTransactionReport -> _sECTransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)sECTransactionReport).map("getPutAmount", _sECTransactionReport -> _sECTransactionReport.getPutAmount()), (CardinalityOperator)CardinalityOperator.All)));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

