/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SECTransactionReportDTCC_SEC_VR_Payment2Payer")
@ImplementedBy(value=Default.class)
public interface SECTransactionReportDTCC_SEC_VR_Payment2Payer
extends Validator<SECTransactionReport> {
    public static final String NAME = "SECTransactionReportDTCC_SEC_VR_Payment2Payer";
    public static final String DEFINITION = "if leg2 -> payerIdentifier exists then (leg2 -> payerIdentifier = counterparty1 or leg2 -> payerIdentifier = counterparty2)";

    public static class NoOp
    implements SECTransactionReportDTCC_SEC_VR_Payment2Payer {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SECTransactionReportDTCC_SEC_VR_Payment2Payer {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
            ComparisonResult result = this.executeDataRule(sECTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SECTransactionReportDTCC_SEC_VR_Payment2Payer.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SECTransactionReport", (RosettaPath)path, (String)SECTransactionReportDTCC_SEC_VR_Payment2Payer.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SECTransactionReportDTCC_SEC_VR_Payment2Payer.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SECTransactionReport", (RosettaPath)path, (String)SECTransactionReportDTCC_SEC_VR_Payment2Payer.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SECTransactionReport sECTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg2", _sECTransactionReport -> _sECTransactionReport.getLeg2()).map("getPayerIdentifier", commonLeg -> commonLeg.getPayerIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg2", _sECTransactionReport -> _sECTransactionReport.getLeg2()).map("getPayerIdentifier", commonLeg -> commonLeg.getPayerIdentifier()), (Mapper)MapperS.of((Object)sECTransactionReport).map("getCounterparty1", _sECTransactionReport -> _sECTransactionReport.getCounterparty1()), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)sECTransactionReport).map("getLeg2", _sECTransactionReport -> _sECTransactionReport.getLeg2()).map("getPayerIdentifier", commonLeg -> commonLeg.getPayerIdentifier()), (Mapper)MapperS.of((Object)sECTransactionReport).map("getCounterparty2", _sECTransactionReport -> _sECTransactionReport.getCounterparty2()), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

