/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromCalculationPeriodDates;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromPaymentDate;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateSettlementDateDefault.class)
public abstract class InterestRateSettlementDate
implements RosettaFunction {
    @Inject
    protected SettlementDateFromCalculationPeriodDates settlementDateFromCalculationPeriodDates;
    @Inject
    protected SettlementDateFromPaymentDate settlementDateFromPaymentDate;

    public List<Date> evaluate(InterestRatePayout interestRatePayout) {
        List<Date> interestRateDate = this.doEvaluate(interestRatePayout);
        return interestRateDate;
    }

    protected abstract List<Date> doEvaluate(InterestRatePayout var1);

    public static class InterestRateSettlementDateDefault
    extends InterestRateSettlementDate {
        @Override
        protected List<Date> doEvaluate(InterestRatePayout interestRatePayout) {
            ArrayList<Date> interestRateDate = new ArrayList<Date>();
            return this.assignOutput(interestRateDate, interestRatePayout);
        }

        protected List<Date> assignOutput(List<Date> interestRateDate, InterestRatePayout interestRatePayout) {
            interestRateDate.addAll(this.settlementDateFromPaymentDate.evaluate((PaymentDates)MapperS.of((Object)interestRatePayout).map("getPaymentDates", _interestRatePayout -> _interestRatePayout.getPaymentDates()).get()));
            interestRateDate.addAll(this.settlementDateFromCalculationPeriodDates.evaluate((CalculationPeriodDates)MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).get()));
            return interestRateDate;
        }
    }
}

