/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.functions;

import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromExerciseTerms;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromSchedule;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromSettlementTerms;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=OptionSettlementDateDefault.class)
public abstract class OptionSettlementDate
implements RosettaFunction {
    @Inject
    protected SettlementDateFromExerciseTerms settlementDateFromExerciseTerms;
    @Inject
    protected SettlementDateFromSchedule settlementDateFromSchedule;
    @Inject
    protected SettlementDateFromSettlementTerms settlementDateFromSettlementTerms;

    public List<Date> evaluate(OptionPayout optionPayout) {
        List<Date> optionDate = this.doEvaluate(optionPayout);
        return optionDate;
    }

    protected abstract List<Date> doEvaluate(OptionPayout var1);

    public static class OptionSettlementDateDefault
    extends OptionSettlementDate {
        @Override
        protected List<Date> doEvaluate(OptionPayout optionPayout) {
            ArrayList<Date> optionDate = new ArrayList<Date>();
            return this.assignOutput(optionDate, optionPayout);
        }

        protected List<Date> assignOutput(List<Date> optionDate, OptionPayout optionPayout) {
            optionDate.addAll(this.settlementDateFromSchedule.evaluate((CalculationSchedule)MapperS.of((Object)optionPayout).map("getSchedule", _optionPayout -> _optionPayout.getSchedule()).get()));
            optionDate.addAll(this.settlementDateFromSettlementTerms.evaluate((SettlementTerms)MapperS.of((Object)optionPayout).map("getSettlementTerms", _optionPayout -> _optionPayout.getSettlementTerms()).get()));
            optionDate.addAll(this.settlementDateFromExerciseTerms.evaluate((OptionExercise)MapperS.of((Object)optionPayout).map("getExerciseTerms", _optionPayout -> _optionPayout.getExerciseTerms()).get()));
            return optionDate;
        }
    }
}

