/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.observable.asset.Price;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.link.functions.PackageInformation;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionPriceRuleDefault.class)
public abstract class PackageTransactionPriceRule
implements ReportFunction<TransactionReportInstructionBase, Price> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PackageInformation packageInformation;

    public Price evaluate(TransactionReportInstructionBase input) {
        Price output;
        Price.PriceBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(Price.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract Price.PriceBuilder doEvaluate(TransactionReportInstructionBase var1);

    public static class PackageTransactionPriceRuleDefault
    extends PackageTransactionPriceRule {
        @Override
        protected Price.PriceBuilder doEvaluate(TransactionReportInstructionBase input) {
            Price.PriceBuilder output = Price.builder();
            return this.assignOutput(output, input);
        }

        protected Price.PriceBuilder assignOutput(Price.PriceBuilder output, TransactionReportInstructionBase input) {
            MapperS thenArg = MapperS.of((Object)this.packageInformation.evaluate(input)).map("getPrice", identifiedList -> identifiedList.getPrice());
            output = (Price.PriceBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getArithmeticOperator", price -> price.getArithmeticOperator())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item;
                }
                return MapperS.ofNull();
            }).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

