/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.functions.CurrencyPairOrCurrencyFromPrice;
import drr.standards.iosco.cde.version1.price.functions.StrikePrice;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceCurrencyRuleDefault.class)
public abstract class StrikePriceCurrencyRule
implements ReportFunction<TransactionReportInstructionBase, String> {
    @Inject
    protected CurrencyPairOrCurrencyFromPrice currencyPairOrCurrencyFromPrice;
    @Inject
    protected StrikePrice strikePrice;

    public String evaluate(TransactionReportInstructionBase input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstructionBase var1);

    public static class StrikePriceCurrencyRuleDefault
    extends StrikePriceCurrencyRule {
        @Override
        protected String doEvaluate(TransactionReportInstructionBase input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstructionBase input) {
            output = this.currencyPairOrCurrencyFromPrice.evaluate(this.strikePrice.evaluate(input), true);
            return output;
        }
    }
}

