/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.math.Measure;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.quantity.functions.CurrencyFromNotional;
import drr.standards.iosco.cde.version1.quantity.functions.Notional;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrencyRuleDefault.class)
public abstract class NotionalCurrencyRule
implements ReportFunction<PayoutLegWithAuxiliary, ISOCurrencyCodeEnum> {
    @Inject
    protected CurrencyFromNotional currencyFromNotional;
    @Inject
    protected Notional notional;

    public ISOCurrencyCodeEnum evaluate(PayoutLegWithAuxiliary input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(PayoutLegWithAuxiliary var1);

    public static class NotionalCurrencyRuleDefault
    extends NotionalCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(PayoutLegWithAuxiliary input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, PayoutLegWithAuxiliary input) {
            MapperS thenArg = MapperS.of((Object)this.notional.evaluate(input));
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)this.currencyFromNotional.evaluate((Measure)thenArg.get())).get();
            return output;
        }
    }
}

