/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iosco.cde.version2.CriticalDataElementV2;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CriticalDataElementV2TypeFormatValidator
implements Validator<CriticalDataElementV2> {
    private List<ComparisonResult> getComparisonResults(CriticalDataElementV2 o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"beneficiary1", (String)o.getBeneficiary1(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"buyerIdentifier", (String)o.getBuyerIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"sellerIdentifier", (String)o.getSellerIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"centralCounterparty", (String)o.getCentralCounterparty(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"clearingMember", (String)o.getClearingMember(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkNumber((String)"callAmount", (BigDecimal)o.getCallAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"putAmount", (BigDecimal)o.getPutAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"delta", (BigDecimal)o.getDelta(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"packageIdentifier", (String)o.getPackageIdentifier(), (int)1, Optional.of(100), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,100}"))), ExpressionOperatorsNullSafe.checkString((String)"priceUnitOfMeasure", (String)o.getPriceUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"optionPremiumAmount", (BigDecimal)o.getOptionPremiumAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"exchangeRate", (BigDecimal)o.getExchangeRate(), Optional.of(18), Optional.of(13), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"exchangeRateBasis", (String)o.getExchangeRateBasis(), (int)7, Optional.of(7), Optional.of(Pattern.compile("[A-Z]{3,3}/[A-Z]{3,3}"))), ExpressionOperatorsNullSafe.checkNumber((String)"cdSIndexAttachmentPoint", (BigDecimal)o.getCdSIndexAttachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"cdSIndexDetachmentPoint", (BigDecimal)o.getCdSIndexDetachmentPoint(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"priorUTI", (String)o.getPriorUTI(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"customBasketCode", (String)o.getCustomBasketCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, CriticalDataElementV2 o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"CriticalDataElementV2", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CriticalDataElementV2", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"CriticalDataElementV2", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CriticalDataElementV2", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

