/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.party.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ReceiverPartyDefault.class)
public abstract class ReceiverParty
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected drr.standards.iosco.cde.version2.party.functions.ReceiverParty receiverParty;

    public Party evaluate(PayoutLegWithAuxiliary payout, List<? extends Counterparty> counterparties) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(payout, counterparties);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(PayoutLegWithAuxiliary var1, List<? extends Counterparty> var2);

    public static class ReceiverPartyDefault
    extends ReceiverParty {
        @Override
        protected Party.PartyBuilder doEvaluate(PayoutLegWithAuxiliary payout, List<? extends Counterparty> counterparties) {
            if (counterparties == null) {
                counterparties = Collections.emptyList();
            }
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, payout, counterparties);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, PayoutLegWithAuxiliary payout, List<? extends Counterparty> counterparties) {
            party = (Party.PartyBuilder)this.toBuilder((RosettaModelObject)this.receiverParty.evaluate(payout, counterparties));
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }
    }
}

