/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.functions;

import drr.standards.iso.functions.ComputeLeiChecksum;

public class ComputeLeiChecksumImpl
extends ComputeLeiChecksum {
    @Override
    protected String doEvaluate(String lei18) {
        if (lei18 == null) {
            return null;
        }
        StringBuilder numeric = new StringBuilder(36);
        for (char c : lei18.toCharArray()) {
            if (c >= '0' && c <= '9') {
                numeric.append(c);
                continue;
            }
            numeric.append(Character.getNumericValue(c));
        }
        numeric.append("00");
        int remainder = 0;
        for (int i = 0; i < numeric.length(); ++i) {
            char digitChar = numeric.charAt(i);
            int digit = digitChar - 48;
            remainder = (remainder * 10 + digit) % 97;
        }
        int check = 98 - remainder;
        return (check < 10 ? "0" : "") + check;
    }
}

