/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.util.string.functions.SubString;
import drr.standards.iso.functions.ComputeLeiChecksum;
import javax.inject.Inject;

@ImplementedBy(value=IsValidLeiDefault.class)
public abstract class IsValidLei
implements RosettaFunction {
    @Inject
    protected ComputeLeiChecksum computeLeiChecksum;
    @Inject
    protected SubString subString;

    public Boolean evaluate(String lei) {
        Boolean valid = this.doEvaluate(lei);
        return valid;
    }

    protected abstract Boolean doEvaluate(String var1);

    protected abstract MapperS<String> existingChecksum(String var1);

    public static class IsValidLeiDefault
    extends IsValidLei {
        @Override
        protected Boolean doEvaluate(String lei) {
            Boolean valid = null;
            return this.assignOutput(valid, lei);
        }

        protected Boolean assignOutput(Boolean valid, String lei) {
            valid = ExpressionOperatorsNullSafe.areEqual(this.existingChecksum(lei), (Mapper)MapperS.of((Object)this.computeLeiChecksum.evaluate(this.subString.evaluate(lei, 1, 18))), (CardinalityOperator)CardinalityOperator.All).get();
            return valid;
        }

        @Override
        protected MapperS<String> existingChecksum(String lei) {
            return MapperS.of((Object)this.subString.evaluate(lei, 19, 2));
        }
    }
}

