package iso20022.auth030.asic.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.OrganisationIdentification15Choice__1;
import iso20022.auth030.asic.TradeReportHeader4__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class TradeReportHeader4__1Validator implements Validator<TradeReportHeader4__1> {

	private List<ComparisonResult> getComparisonResults(TradeReportHeader4__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("nbRcrds", (Long) o.getNbRcrds() != null ? 1 : 0, 1, 1), 
				checkCardinality("newTradRpstryIdr", (OrganisationIdentification15Choice__1) o.getNewTradRpstryIdr() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeReportHeader4__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("TradeReportHeader4__1", ValidationResult.ValidationType.CARDINALITY, "TradeReportHeader4__1", path, "", res.getError());
				}
				return success("TradeReportHeader4__1", ValidationResult.ValidationType.CARDINALITY, "TradeReportHeader4__1", path, "");
			})
			.collect(toList());
	}

}
