package iso20022.auth030.hkma.tr;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.tr.meta.AmountAndDirection109__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Posting of an item to a cash account, in the context of a cash transaction, that results in an increase or decrease to the balance of the account.
 * @version ${project.version}
 */
@RosettaDataType(value="AmountAndDirection109__1", builder=AmountAndDirection109__1.AmountAndDirection109__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="AmountAndDirection109__1", model="iso20022", builder=AmountAndDirection109__1.AmountAndDirection109__1BuilderImpl.class, version="${project.version}")
public interface AmountAndDirection109__1 extends RosettaModelObject {

	AmountAndDirection109__1Meta metaData = new AmountAndDirection109__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Amount of money in the cash entry.
	 */
	ActiveOrHistoricCurrencyAnd5DecimalAmount getAmt();
	/**
	 * Indicates that the amount value is positive or negative.
	 */
	Boolean getSgn();

	/*********************** Build Methods  ***********************/
	AmountAndDirection109__1 build();
	
	AmountAndDirection109__1.AmountAndDirection109__1Builder toBuilder();
	
	static AmountAndDirection109__1.AmountAndDirection109__1Builder builder() {
		return new AmountAndDirection109__1.AmountAndDirection109__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AmountAndDirection109__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AmountAndDirection109__1> getType() {
		return AmountAndDirection109__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("amt"), processor, ActiveOrHistoricCurrencyAnd5DecimalAmount.class, getAmt());
		processor.processBasic(path.newSubPath("sgn"), Boolean.class, getSgn(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface AmountAndDirection109__1Builder extends AmountAndDirection109__1, RosettaModelObjectBuilder {
		ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getOrCreateAmt();
		@Override
		ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getAmt();
		AmountAndDirection109__1.AmountAndDirection109__1Builder setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount amt);
		AmountAndDirection109__1.AmountAndDirection109__1Builder setSgn(Boolean sgn);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("amt"), processor, ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder.class, getAmt());
			processor.processBasic(path.newSubPath("sgn"), Boolean.class, getSgn(), this);
		}
		

		AmountAndDirection109__1.AmountAndDirection109__1Builder prune();
	}

	/*********************** Immutable Implementation of AmountAndDirection109__1  ***********************/
	class AmountAndDirection109__1Impl implements AmountAndDirection109__1 {
		private final ActiveOrHistoricCurrencyAnd5DecimalAmount amt;
		private final Boolean sgn;
		
		protected AmountAndDirection109__1Impl(AmountAndDirection109__1.AmountAndDirection109__1Builder builder) {
			this.amt = ofNullable(builder.getAmt()).map(f->f.build()).orElse(null);
			this.sgn = builder.getSgn();
		}
		
		@Override
		@RosettaAttribute(value="amt", isRequired=true)
		@RuneAttribute(value="amt", isRequired=true)
		public ActiveOrHistoricCurrencyAnd5DecimalAmount getAmt() {
			return amt;
		}
		
		@Override
		@RosettaAttribute("sgn")
		@RuneAttribute("sgn")
		public Boolean getSgn() {
			return sgn;
		}
		
		@Override
		public AmountAndDirection109__1 build() {
			return this;
		}
		
		@Override
		public AmountAndDirection109__1.AmountAndDirection109__1Builder toBuilder() {
			AmountAndDirection109__1.AmountAndDirection109__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AmountAndDirection109__1.AmountAndDirection109__1Builder builder) {
			ofNullable(getAmt()).ifPresent(builder::setAmt);
			ofNullable(getSgn()).ifPresent(builder::setSgn);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AmountAndDirection109__1 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			if (!Objects.equals(sgn, _that.getSgn())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			_result = 31 * _result + (sgn != null ? sgn.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AmountAndDirection109__1 {" +
				"amt=" + this.amt + ", " +
				"sgn=" + this.sgn +
			'}';
		}
	}

	/*********************** Builder Implementation of AmountAndDirection109__1  ***********************/
	class AmountAndDirection109__1BuilderImpl implements AmountAndDirection109__1.AmountAndDirection109__1Builder {
	
		protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder amt;
		protected Boolean sgn;
		
		@Override
		@RosettaAttribute(value="amt", isRequired=true)
		@RuneAttribute(value="amt", isRequired=true)
		public ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getAmt() {
			return amt;
		}
		
		@Override
		public ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getOrCreateAmt() {
			ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder result;
			if (amt!=null) {
				result = amt;
			}
			else {
				result = amt = ActiveOrHistoricCurrencyAnd5DecimalAmount.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("sgn")
		@RuneAttribute("sgn")
		public Boolean getSgn() {
			return sgn;
		}
		
		@RosettaAttribute(value="amt", isRequired=true)
		@RuneAttribute(value="amt", isRequired=true)
		@Override
		public AmountAndDirection109__1.AmountAndDirection109__1Builder setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount _amt) {
			this.amt = _amt == null ? null : _amt.toBuilder();
			return this;
		}
		
		@RosettaAttribute("sgn")
		@RuneAttribute("sgn")
		@Override
		public AmountAndDirection109__1.AmountAndDirection109__1Builder setSgn(Boolean _sgn) {
			this.sgn = _sgn == null ? null : _sgn;
			return this;
		}
		
		@Override
		public AmountAndDirection109__1 build() {
			return new AmountAndDirection109__1.AmountAndDirection109__1Impl(this);
		}
		
		@Override
		public AmountAndDirection109__1.AmountAndDirection109__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AmountAndDirection109__1.AmountAndDirection109__1Builder prune() {
			if (amt!=null && !amt.prune().hasData()) amt = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAmt()!=null && getAmt().hasData()) return true;
			if (getSgn()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AmountAndDirection109__1.AmountAndDirection109__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AmountAndDirection109__1.AmountAndDirection109__1Builder o = (AmountAndDirection109__1.AmountAndDirection109__1Builder) other;
			
			merger.mergeRosetta(getAmt(), o.getAmt(), this::setAmt);
			
			merger.mergeBasic(getSgn(), o.getSgn(), this::setSgn);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AmountAndDirection109__1 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			if (!Objects.equals(sgn, _that.getSgn())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			_result = 31 * _result + (sgn != null ? sgn.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AmountAndDirection109__1Builder {" +
				"amt=" + this.amt + ", " +
				"sgn=" + this.sgn +
			'}';
		}
	}
}
