package iso20022.auth108.iso.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.iso.TradeData55Choice;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class TradeData55ChoiceTypeFormatValidator implements Validator<TradeData55Choice> {

	private List<ComparisonResult> getComparisonResults(TradeData55Choice o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeData55Choice o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("TradeData55Choice", ValidationResult.ValidationType.TYPE_FORMAT, "TradeData55Choice", path, "", res.getError());
				}
				return success("TradeData55Choice", ValidationResult.ValidationType.TYPE_FORMAT, "TradeData55Choice", path, "");
			})
			.collect(toList());
	}

}
