package drr.base.trade.basket.functions;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.template.Basket;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import javax.inject.Inject;


@ImplementedBy(UnderlierBasketIdentifier.UnderlierBasketIdentifierDefault.class)
public abstract class UnderlierBasketIdentifier implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CreditBasketIdentifier creditBasketIdentifier;

	/**
	* @param underlier 
	* @return identifier 
	*/
	public String evaluate(Product underlier) {
		String identifier = doEvaluate(underlier);
		
		return identifier;
	}

	protected abstract String doEvaluate(Product underlier);

	public static class UnderlierBasketIdentifierDefault extends UnderlierBasketIdentifier {
		@Override
		protected String doEvaluate(Product underlier) {
			String identifier = null;
			return assignOutput(identifier, underlier);
		}
		
		protected String assignOutput(String identifier, Product underlier) {
			identifier = MapperS.of(underlier).<Basket>map("getBasket", product -> product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())
				.first().<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()).getOrDefault(creditBasketIdentifier.evaluate(MapperS.of(underlier).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get()));
			
			return identifier;
		}
	}
}
