package drr.base.trade.underlier.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.BondReference;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.ReferenceInformation;
import cdm.product.asset.ReferenceObligation;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.template.Basket;
import cdm.product.template.ContractualProduct;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsFRA;
import drr.base.qualification.product.functions.IsProductETD;
import drr.base.trade.functions.EconomicTermsForProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UnderlierProductIdentifier.UnderlierProductIdentifierDefault.class)
public abstract class UnderlierProductIdentifier implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FilterProductIdentifier filterProductIdentifier;
	@Inject protected IsFRA isFRA;
	@Inject protected IsProductETD isProductETD;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @param identifierType 
	* @return productId 
	*/
	public List<? extends ProductIdentifier> evaluate(Product product, ProductIdTypeEnum identifierType) {
		List<ProductIdentifier.ProductIdentifierBuilder> productIdBuilder = doEvaluate(product, identifierType);
		
		final List<? extends ProductIdentifier> productId;
		if (productIdBuilder == null) {
			productId = null;
		} else {
			productId = productIdBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
			objectValidator.validate(ProductIdentifier.class, productId);
		}
		
		return productId;
	}

	protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperS<? extends Payout> productPayout(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperS<? extends Payout> underlierPayout(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ReferenceObligation> cdsProduct(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ReferenceObligation> cdsUnderlying(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperS<? extends CreditIndexReferenceInformation> cdsIndexUnderlying(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperS<? extends CreditIndexReferenceInformation> cdsIndex(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends IndexReferenceInformation> floatingRateIndex(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends IndexReferenceInformation> inflationRateIndex(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> cdsProductID(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> underlierProductID(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> etdProductID(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ProductIdentifier> otcProductID(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ProductIdentifier> indexProductId(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperS<? extends ProductIdentifier> indexNoProductId(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketProductId(Product product, ProductIdTypeEnum identifierType);

	protected abstract MapperC<? extends ProductIdentifier> basketNoProductId(Product product, ProductIdTypeEnum identifierType);

	public static class UnderlierProductIdentifierDefault extends UnderlierProductIdentifier {
		@Override
		protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product, ProductIdTypeEnum identifierType) {
			List<ProductIdentifier.ProductIdentifierBuilder> productId = new ArrayList<>();
			return assignOutput(productId, product, identifierType);
		}
		
		protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> productId, Product product, ProductIdTypeEnum identifierType) {
			final MapperC<ProductIdentifier> thenArg = MapperC.<ProductIdentifier>of(cdsProductID(product, identifierType).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), underlierProductID(product, identifierType).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), etdProductID(product, identifierType).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), otcProductID(product, identifierType), indexProductId(product, identifierType), indexNoProductId(product, identifierType), basketProductId(product, identifierType).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), basketNoProductId(product, identifierType));
			final MapperC<ProductIdentifier> ifThenElseResult;
			if (exists(MapperS.of(identifierType)).getOrDefault(false)) {
				ifThenElseResult = MapperC.of(Collections.singletonList(filterProductIdentifier.evaluate(thenArg.getMulti(), identifierType)));
			} else {
				ifThenElseResult = thenArg;
			}
			productId.addAll(toBuilder(ifThenElseResult.getMulti()));
			
			return Optional.ofNullable(productId)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends Payout> productPayout(Product product, ProductIdTypeEnum identifierType) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout());
		}
		
		@Override
		protected MapperS<? extends Payout> underlierPayout(Product product, ProductIdTypeEnum identifierType) {
			return MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout());
		}
		
		@Override
		protected MapperC<? extends ReferenceObligation> cdsProduct(Product product, ProductIdTypeEnum identifierType) {
			return productPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation());
		}
		
		@Override
		protected MapperC<? extends ReferenceObligation> cdsUnderlying(Product product, ProductIdTypeEnum identifierType) {
			return underlierPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).<ReferenceObligation>mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation());
		}
		
		@Override
		protected MapperS<? extends CreditIndexReferenceInformation> cdsIndexUnderlying(Product product, ProductIdTypeEnum identifierType) {
			return underlierPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
		}
		
		@Override
		protected MapperS<? extends CreditIndexReferenceInformation> cdsIndex(Product product, ProductIdTypeEnum identifierType) {
			return productPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
		}
		
		@Override
		protected MapperC<? extends IndexReferenceInformation> floatingRateIndex(Product product, ProductIdTypeEnum identifierType) {
			return productPayout(product, identifierType).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation());
		}
		
		@Override
		protected MapperC<? extends IndexReferenceInformation> inflationRateIndex(Product product, ProductIdTypeEnum identifierType) {
			return productPayout(product, identifierType).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> cdsProductID(Product product, ProductIdTypeEnum identifierType) {
			final MapperC<? extends ReferenceObligation> thenArg0;
			if (exists(cdsProduct(product, identifierType)).getOrDefault(false)) {
				thenArg0 = cdsProduct(product, identifierType);
			} else if (exists(cdsUnderlying(product, identifierType)).getOrDefault(false)) {
				thenArg0 = cdsUnderlying(product, identifierType);
			} else {
				thenArg0 = MapperC.<ReferenceObligation>ofNull();
			}
			final MapperListOfLists<ReferenceWithMetaProductIdentifier> thenArg1 = thenArg0
				.mapItemToList(item -> {
					if (exists(item.<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(false)) {
						return item.<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
					}
					if (exists(item.<Loan>map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(false)) {
						return item.<Loan>map("getLoan", referenceObligation -> referenceObligation.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
					}
					return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
				});
			return thenArg1
				.flattenList();
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> underlierProductID(Product product, ProductIdTypeEnum identifierType) {
			final MapperS<Product> thenArg;
			if (exists(MapperS.of(underlierForProduct.evaluate(product))).getOrDefault(false)) {
				thenArg = MapperS.of(underlierForProduct.evaluate(product));
			} else {
				thenArg = MapperS.<Product>ofNull();
			}
			return thenArg
				.mapSingleToList(item -> {
					if (exists(item.<Security>map("getSecurity", _product -> _product.getSecurity())).getOrDefault(false)) {
						return item.<Security>map("getSecurity", _product -> _product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
					}
					if (exists(item.<Loan>map("getLoan", _product -> _product.getLoan())).getOrDefault(false)) {
						return item.<Loan>map("getLoan", _product -> _product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
					}
					if (exists(item.<Index>map("getIndex", _product -> _product.getIndex())).getOrDefault(false)) {
						return item.<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
					}
					if (exists(item.<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity())).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isProductETD.evaluate(product)))).getOrDefault(false)) {
						return item.<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
					}
					return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
				});
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> etdProductID(Product product, ProductIdTypeEnum identifierType) {
			final Boolean _boolean = isProductETD.evaluate(product);
			if ((_boolean == null ? false : _boolean)) {
				if (exists(MapperS.of(underlierForProduct.evaluate(product)).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity0 -> referenceWithMetaCommodity0 == null ? null : referenceWithMetaCommodity0.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())).getOrDefault(false)) {
					return MapperS.of(underlierForProduct.evaluate(product)).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity1 -> referenceWithMetaCommodity1 == null ? null : referenceWithMetaCommodity1.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
				}
				if (exists(MapperS.of(underlierForProduct.evaluate(underlierForProduct.evaluate(product))).<Index>map("getIndex", _product -> _product.getIndex())).getOrDefault(false)) {
					return MapperS.of(underlierForProduct.evaluate(underlierForProduct.evaluate(product))).<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
				}
				return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
			}
			return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
		}
		
		@Override
		protected MapperC<? extends ProductIdentifier> otcProductID(Product product, ProductIdTypeEnum identifierType) {
			if (exists(MapperS.of(underlierForProduct.evaluate(product)).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())).getOrDefault(false)) {
				return MapperS.of(underlierForProduct.evaluate(product)).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
			}
			if (exists(MapperS.of(underlierForProduct.evaluate(product)).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())).getOrDefault(false)) {
				return MapperS.of(underlierForProduct.evaluate(product)).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
			}
			if (exists(productPayout(product, identifierType).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<BondReference>map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).<ProductIdentifier>map("getBond", bondReference -> bondReference.getBond())).getOrDefault(false)) {
				return productPayout(product, identifierType).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<BondReference>map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).<ProductIdentifier>map("getBond", bondReference -> bondReference.getBond());
			}
			if (exists(productPayout(product, identifierType).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())).getOrDefault(false)) {
				return productPayout(product, identifierType).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
			}
			return MapperC.<ProductIdentifier>ofNull();
		}
		
		@Override
		protected MapperC<? extends ProductIdentifier> indexProductId(Product product, ProductIdTypeEnum identifierType) {
			if (exists(cdsIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier())).getOrDefault(false)) {
				return cdsIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier());
			}
			if (exists(cdsIndexUnderlying(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier())).getOrDefault(false)) {
				return cdsIndexUnderlying(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier());
			}
			if (ComparisonResult.ofNullSafe(MapperS.of(isFRA.evaluate(product))).andNullSafe(exists(floatingRateIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()))).getOrDefault(false)) {
				return floatingRateIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier());
			}
			final Boolean boolean0 = qualify_BaseProduct_IRSwap.evaluate(economicTermsForProduct.evaluate(product));
			if ((boolean0 == null ? false : boolean0)) {
				return MapperC.<ProductIdentifier>of(floatingRateIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()), floatingRateIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()));
			}
			final Boolean boolean1 = qualify_BaseProduct_IRSwap.evaluate(economicTermsForProduct.evaluate(product));
			if ((boolean1 == null ? false : boolean1)) {
				return MapperC.<ProductIdentifier>of(floatingRateIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()), inflationRateIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()));
			}
			return MapperC.<ProductIdentifier>ofNull();
		}
		
		@Override
		protected MapperS<? extends ProductIdentifier> indexNoProductId(Product product, ProductIdTypeEnum identifierType) {
			if (exists(cdsIndex(product, identifierType).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName())).andNullSafe(notExists(cdsIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier()))).getOrDefault(false)) {
				return MapperS.of(ProductIdentifier.builder()
					.setIdentifier(cdsIndex(product, identifierType).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).get())
					.setSource(ProductIdTypeEnum.NAME)
					.build());
			}
			if (exists(cdsIndexUnderlying(product, identifierType).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName())).andNullSafe(notExists(cdsIndexUnderlying(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier()))).getOrDefault(false)) {
				return MapperS.of(ProductIdentifier.builder()
					.setIdentifier(cdsIndexUnderlying(product, identifierType).<FieldWithMetaString>map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).get())
					.setSource(ProductIdTypeEnum.NAME)
					.build());
			}
			if (exists(floatingRateIndex(product, identifierType).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())).andNullSafe(notExists(floatingRateIndex(product, identifierType).<ProductIdentifier>mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()))).getOrDefault(false)) {
				return MapperS.of(ProductIdentifier.builder()
					.setIdentifier(floatingRateIndex(product, identifierType).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName()).get())
					.setSource(ProductIdTypeEnum.NAME)
					.build());
			}
			return MapperS.<ProductIdentifier>ofNull();
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketProductId(Product product, ProductIdTypeEnum identifierType) {
			if (exists(MapperS.of(underlierForProduct.evaluate(product)).<Basket>map("getBasket", _product -> _product.getBasket())).getOrDefault(false)) {
				return MapperS.of(underlierForProduct.evaluate(product)).<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier());
			}
			return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
		}
		
		@Override
		protected MapperC<? extends ProductIdentifier> basketNoProductId(Product product, ProductIdTypeEnum identifierType) {
			if (exists(productPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<FieldWithMetaString>mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId())).getOrDefault(false)) {
				return productPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<FieldWithMetaString>mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId())
					.mapItem(item -> MapperS.of(ProductIdentifier.builder()
						.setIdentifier(item.get())
						.setSource(ProductIdTypeEnum.OTHER)
						.build()));
			}
			if (exists(underlierPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<FieldWithMetaString>mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId())).getOrDefault(false)) {
				return underlierPayout(product, identifierType).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<FieldWithMetaString>mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId())
					.mapItem(item -> MapperS.of(ProductIdentifier.builder()
						.setIdentifier(item.get())
						.setSource(ProductIdTypeEnum.OTHER)
						.build()));
			}
			return MapperC.<ProductIdentifier>ofNull();
		}
	}
}
