package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.party.Address;
import cdm.base.staticdata.party.ContactInformation;
import cdm.base.staticdata.party.NaturalPerson;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.ReportingSide;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CountryOfCounterparty2Rule.CountryOfCounterparty2RuleDefault.class)
public abstract class CountryOfCounterparty2Rule implements ReportFunction<TransactionReportInstruction, ISOCountryCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCountryCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCountryCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCountryCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class CountryOfCounterparty2RuleDefault extends CountryOfCounterparty2Rule {
		@Override
		protected ISOCountryCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCountryCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCountryCodeEnum assignOutput(ISOCountryCodeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(reportInstruction -> {
					final MapperC<RegimePartyInformation> thenArg0 = thenArg
						.mapSingleToList(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<RegimePartyInformation>mapC("getRegimePartyInformation", reportableInformation -> reportableInformation.getRegimePartyInformation()));
					final MapperC<RegimePartyInformation> thenArg1 = thenArg0
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), reportInstruction.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperS<RegimePartyInformation> thenArg2 = MapperS.of(thenArg1.get());
					final MapperS<FieldWithMetaString> thenArg3 = thenArg2
						.mapSingleToItem(item -> {
							if (notEqual(item.<ReferenceWithMetaParty>map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).<PartyIdentifierTypeEnum>map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), MapperS.of(PartyIdentifierTypeEnum.LEI), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(MapperS.of(item.<ReferenceWithMetaParty>map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()).<ContactInformation>map("getContactInformation", party -> party.getContactInformation()).<Address>mapC("getAddress", contactInformation -> contactInformation.getAddress()).<FieldWithMetaString>map("getCountry", address -> address.getCountry()).get()).getOrDefault(item.<ReferenceWithMetaParty>map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty2 -> referenceWithMetaParty2 == null ? null : referenceWithMetaParty2.getValue()).<NaturalPerson>mapC("getPerson", party -> party.getPerson()).<ContactInformation>map("getContactInformation", naturalPerson -> naturalPerson.getContactInformation()).<Address>mapC("getAddress", contactInformation -> contactInformation.getAddress()).<FieldWithMetaString>map("getCountry", address -> address.getCountry()).get()));
							}
							return MapperS.<FieldWithMetaString>ofNull();
						});
					return thenArg3
						.mapSingleToItem(item -> item.<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()).checkedMap("to-enum", ISOCountryCodeEnum::fromDisplayName, IllegalArgumentException.class));
				}).get();
			
			return output;
		}
	}
}
