package drr.regulation.cftc.rewrite.dtcc.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.MandatorilyClearableEnum;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(DTCC_MandatoryClearingIndicatorRule.DTCC_MandatoryClearingIndicatorRuleDefault.class)
public abstract class DTCC_MandatoryClearingIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCFTC isAllowableActionForCFTC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class DTCC_MandatoryClearingIndicatorRuleDefault extends DTCC_MandatoryClearingIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCFTC.evaluate(item.get()));
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.mapSingleToList(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<RegimePartyInformation>mapC("getRegimePartyInformation", reportableInformation -> reportableInformation.getRegimePartyInformation()).<ReportingRegime>mapC("getRegimeInformation", regimePartyInformation -> regimePartyInformation.getRegimeInformation()));
			final MapperC<ReportingRegime> thenArg2 = thenArg1
				.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).get());
			final MapperC<Boolean> thenArg3 = thenArg2
				.mapItem(item -> {
					if (areEqual(item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_AND_CPTY_MANDATORY), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(true);
					}
					if (areEqual(item.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable()), MapperS.of(MandatorilyClearableEnum.PRODUCT_MANDATORY_BUT_NOT_CPTY), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(false);
					}
					return MapperS.<Boolean>ofNull();
				});
			output = MapperS.of(distinct(thenArg3).get()).get();
			
			return output;
		}
	}
}
