package drr.regulation.cftc.rewrite.dtcc.trade.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportingSide;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.CFTCEntityClassificationEnum;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(DTCC_SDMSPIndicatorCounterparty1Rule.DTCC_SDMSPIndicatorCounterparty1RuleDefault.class)
public abstract class DTCC_SDMSPIndicatorCounterparty1Rule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCFTC isAllowableActionForCFTC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class DTCC_SDMSPIndicatorCounterparty1RuleDefault extends DTCC_SDMSPIndicatorCounterparty1Rule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCFTC.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(reportInstruction -> {
					final MapperC<RegimePartyInformation> thenArg0 = reportInstruction.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<RegimePartyInformation>mapC("getRegimePartyInformation", reportableInformation -> reportableInformation.getRegimePartyInformation())
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), reportInstruction.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperC<RegimePartyInformation> thenArg1 = thenArg0
						.filterItemNullSafe(item -> exists(item.<ReportingRegime>mapC("getRegimeInformation", regimePartyInformation -> regimePartyInformation.getRegimeInformation()).<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<CFTCEntityClassificationEnum>map("getOrganizationType", cFTCPartyInformation -> cFTCPartyInformation.getOrganizationType())).get());
					final MapperListOfLists<ReportingRegime> thenArg2 = thenArg1
						.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", regimePartyInformation -> regimePartyInformation.getRegimeInformation()));
					final MapperC<ReportingRegime> thenArg3 = thenArg2
						.flattenList();
					final MapperC<ReportingRegime> thenArg4 = thenArg3
						.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).get());
					final MapperS<ReportingRegime> thenArg5 = MapperS.of(thenArg4.get());
					return thenArg5
						.mapSingleToItem(item -> {
							if (areEqual(item.<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<CFTCEntityClassificationEnum>map("getOrganizationType", cFTCPartyInformation -> cFTCPartyInformation.getOrganizationType()), MapperS.of(CFTCEntityClassificationEnum.SD), CardinalityOperator.All).orNullSafe(areEqual(item.<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<CFTCEntityClassificationEnum>map("getOrganizationType", cFTCPartyInformation -> cFTCPartyInformation.getOrganizationType()), MapperS.of(CFTCEntityClassificationEnum.MSP), CardinalityOperator.All)).getOrDefault(false)) {
								return MapperS.of(true);
							}
							return MapperS.of(false);
						});
				}).get();
			
			return output;
		}
	}
}
