package drr.regulation.cftc.rewrite.dtcc.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ValuationReportInstruction;


@ImplementedBy(DTCC_UTIIDPrefixRule.DTCC_UTIIDPrefixRuleDefault.class)
public abstract class DTCC_UTIIDPrefixRule implements ReportFunction<ValuationReportInstruction, Void> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Void evaluate(ValuationReportInstruction input) {
		Void output = doEvaluate(input);
		
		return output;
	}

	protected abstract Void doEvaluate(ValuationReportInstruction input);

	public static class DTCC_UTIIDPrefixRuleDefault extends DTCC_UTIIDPrefixRule {
		@Override
		protected Void doEvaluate(ValuationReportInstruction input) {
			Void output = null;
			return assignOutput(output, input);
		}
		
		protected Void assignOutput(Void output, ValuationReportInstruction input) {
			output = null;
			
			return output;
		}
	}
}
