package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PartyInformation;
import drr.base.util.party.functions.ExtractPartyFromRelatedPartyByRole;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PrimeBrokerageTransactionIndicatorFunc.PrimeBrokerageTransactionIndicatorFuncDefault.class)
public abstract class PrimeBrokerageTransactionIndicatorFunc implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;

	/**
	* @param transaction 
	* @return indicator 
	*/
	public Boolean evaluate(TransactionReportInstruction transaction) {
		Boolean indicator = doEvaluate(transaction);
		
		return indicator;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction transaction);

	protected abstract MapperS<Boolean> primeBrokerExists(TransactionReportInstruction transaction);

	protected abstract MapperC<? extends RegimePartyInformation> executingBrokerPartyInfo(TransactionReportInstruction transaction);

	protected abstract MapperS<Boolean> executingBrokerIsUSPerson(TransactionReportInstruction transaction);

	public static class PrimeBrokerageTransactionIndicatorFuncDefault extends PrimeBrokerageTransactionIndicatorFunc {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction transaction) {
			Boolean indicator = null;
			return assignOutput(indicator, transaction);
		}
		
		protected Boolean assignOutput(Boolean indicator, TransactionReportInstruction transaction) {
			indicator = ComparisonResult.ofNullSafe(primeBrokerExists(transaction)).andNullSafe(ComparisonResult.ofNullSafe(executingBrokerIsUSPerson(transaction))).get();
			
			return indicator;
		}
		
		@Override
		protected MapperS<Boolean> primeBrokerExists(TransactionReportInstruction transaction) {
			return exists(MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(MapperS.of(transaction).<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.PRIME_BROKER))).asMapper();
		}
		
		@Override
		protected MapperC<? extends RegimePartyInformation> executingBrokerPartyInfo(TransactionReportInstruction transaction) {
			return MapperS.of(transaction).<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<RegimePartyInformation>mapC("getRegimePartyInformation", reportableInformation -> reportableInformation.getRegimePartyInformation())
				.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(MapperS.of(transaction).<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTING_BROKER)), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperS<Boolean> executingBrokerIsUSPerson(TransactionReportInstruction transaction) {
			return MapperS.of(executingBrokerPartyInfo(transaction).<ReportingRegime>mapC("getRegimeInformation", regimePartyInformation -> regimePartyInformation.getRegimeInformation()).<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<Boolean>map("getIsUSPerson", cFTCPartyInformation -> cFTCPartyInformation.getIsUSPerson())
				.first().getOrDefault(false));
		}
	}
}
