package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version2.party.functions.ReceiverParty;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(ReceiverPartyLeg1.ReceiverPartyLeg1Default.class)
public abstract class ReceiverPartyLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CounterpartiesForEvent counterpartiesForEvent;
	@Inject protected PayoutLeg1Rule payoutLeg1Rule;
	@Inject protected ReceiverParty receiverParty;

	/**
	* @param transacion 
	* @return party 
	*/
	public Party evaluate(TransactionReportInstruction transacion) {
		Party.PartyBuilder partyBuilder = doEvaluate(transacion);
		
		final Party party;
		if (partyBuilder == null) {
			party = null;
		} else {
			party = partyBuilder.build();
			objectValidator.validate(Party.class, party);
		}
		
		return party;
	}

	protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction transacion);

	public static class ReceiverPartyLeg1Default extends ReceiverPartyLeg1 {
		@Override
		protected Party.PartyBuilder doEvaluate(TransactionReportInstruction transacion) {
			Party.PartyBuilder party = Party.builder();
			return assignOutput(party, transacion);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, TransactionReportInstruction transacion) {
			party = toBuilder(receiverParty.evaluate(payoutLeg1Rule.evaluate(transacion), counterpartiesForEvent.evaluate(transacion)));
			
			return Optional.ofNullable(party)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
