package drr.regulation.cftc.rewrite.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportingSide;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.CFTCFinancialEntityClassificationEnum;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.party.functions.ExtractRegimeInformation;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Counterparty2FinancialEntityIndicatorRule.Counterparty2FinancialEntityIndicatorRuleDefault.class)
public abstract class Counterparty2FinancialEntityIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractRegimeInformation extractRegimeInformation;
	@Inject protected IsAllowableActionForCFTC isAllowableActionForCFTC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class Counterparty2FinancialEntityIndicatorRuleDefault extends Counterparty2FinancialEntityIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCFTC.evaluate(item.get()));
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.mapSingleToList(item -> {
					final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).get();
					return MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue())));
				});
			final MapperS<Boolean> ifThenElseResult;
			if (exists(thenArg1.<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<CFTCFinancialEntityClassificationEnum>map("getFinancialEntity", cFTCPartyInformation -> cFTCPartyInformation.getFinancialEntity())).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(true);
			} else {
				ifThenElseResult = MapperS.of(false);
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
