package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.CommonTransactionInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 7.0.0-dev.101
 */
@RosettaDataType(value="CommonTransactionInformation", builder=CommonTransactionInformation.CommonTransactionInformationBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="CommonTransactionInformation", model="drr", builder=CommonTransactionInformation.CommonTransactionInformationBuilderImpl.class, version="7.0.0-dev.101")
public interface CommonTransactionInformation extends RosettaModelObject {

	CommonTransactionInformationMeta metaData = new CommonTransactionInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Whether the financial instrument is admitted to trading, or traded on a trading venue or for which a request for admission was made.
	 */
	TradableOnTradingVenueEnum getTradableOnTradingVenue();
	/**
	 * Indicator of whether the product underlier of the reportable trade is traded on a trading venue.
	 */
	Boolean getUnderlierTradedOnTradingVenue();
	/**
	 * For a platform (e.g. exchange) traded underlying asset, the platform on which the asset is traded.
	 */
	String getUnderlierAssetTradingPlatformIdentifier();
	/**
	 * Unique internal identifier created and used by the user to identify the transaction.
	 */
	String getInternalTradeIdentifier();

	/*********************** Build Methods  ***********************/
	CommonTransactionInformation build();
	
	CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder();
	
	static CommonTransactionInformation.CommonTransactionInformationBuilder builder() {
		return new CommonTransactionInformation.CommonTransactionInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CommonTransactionInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CommonTransactionInformation> getType() {
		return CommonTransactionInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, getTradableOnTradingVenue(), this);
		processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
		processor.processBasic(path.newSubPath("underlierAssetTradingPlatformIdentifier"), String.class, getUnderlierAssetTradingPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("internalTradeIdentifier"), String.class, getInternalTradeIdentifier(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CommonTransactionInformationBuilder extends CommonTransactionInformation, RosettaModelObjectBuilder {
		CommonTransactionInformation.CommonTransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum tradableOnTradingVenue);
		CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean underlierTradedOnTradingVenue);
		CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierAssetTradingPlatformIdentifier(String underlierAssetTradingPlatformIdentifier);
		CommonTransactionInformation.CommonTransactionInformationBuilder setInternalTradeIdentifier(String internalTradeIdentifier);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, getTradableOnTradingVenue(), this);
			processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
			processor.processBasic(path.newSubPath("underlierAssetTradingPlatformIdentifier"), String.class, getUnderlierAssetTradingPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("internalTradeIdentifier"), String.class, getInternalTradeIdentifier(), this);
		}
		

		CommonTransactionInformation.CommonTransactionInformationBuilder prune();
	}

	/*********************** Immutable Implementation of CommonTransactionInformation  ***********************/
	class CommonTransactionInformationImpl implements CommonTransactionInformation {
		private final TradableOnTradingVenueEnum tradableOnTradingVenue;
		private final Boolean underlierTradedOnTradingVenue;
		private final String underlierAssetTradingPlatformIdentifier;
		private final String internalTradeIdentifier;
		
		protected CommonTransactionInformationImpl(CommonTransactionInformation.CommonTransactionInformationBuilder builder) {
			this.tradableOnTradingVenue = builder.getTradableOnTradingVenue();
			this.underlierTradedOnTradingVenue = builder.getUnderlierTradedOnTradingVenue();
			this.underlierAssetTradingPlatformIdentifier = builder.getUnderlierAssetTradingPlatformIdentifier();
			this.internalTradeIdentifier = builder.getInternalTradeIdentifier();
		}
		
		@Override
		@RosettaAttribute("tradableOnTradingVenue")
		@RuneAttribute("tradableOnTradingVenue")
		public TradableOnTradingVenueEnum getTradableOnTradingVenue() {
			return tradableOnTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		public Boolean getUnderlierTradedOnTradingVenue() {
			return underlierTradedOnTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierAssetTradingPlatformIdentifier")
		@RuneAttribute("underlierAssetTradingPlatformIdentifier")
		public String getUnderlierAssetTradingPlatformIdentifier() {
			return underlierAssetTradingPlatformIdentifier;
		}
		
		@Override
		@RosettaAttribute("internalTradeIdentifier")
		@RuneAttribute("internalTradeIdentifier")
		public String getInternalTradeIdentifier() {
			return internalTradeIdentifier;
		}
		
		@Override
		public CommonTransactionInformation build() {
			return this;
		}
		
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder() {
			CommonTransactionInformation.CommonTransactionInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CommonTransactionInformation.CommonTransactionInformationBuilder builder) {
			ofNullable(getTradableOnTradingVenue()).ifPresent(builder::setTradableOnTradingVenue);
			ofNullable(getUnderlierTradedOnTradingVenue()).ifPresent(builder::setUnderlierTradedOnTradingVenue);
			ofNullable(getUnderlierAssetTradingPlatformIdentifier()).ifPresent(builder::setUnderlierAssetTradingPlatformIdentifier);
			ofNullable(getInternalTradeIdentifier()).ifPresent(builder::setInternalTradeIdentifier);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(tradableOnTradingVenue, _that.getTradableOnTradingVenue())) return false;
			if (!Objects.equals(underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) return false;
			if (!Objects.equals(underlierAssetTradingPlatformIdentifier, _that.getUnderlierAssetTradingPlatformIdentifier())) return false;
			if (!Objects.equals(internalTradeIdentifier, _that.getInternalTradeIdentifier())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (tradableOnTradingVenue != null ? tradableOnTradingVenue.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlierTradedOnTradingVenue != null ? underlierTradedOnTradingVenue.hashCode() : 0);
			_result = 31 * _result + (underlierAssetTradingPlatformIdentifier != null ? underlierAssetTradingPlatformIdentifier.hashCode() : 0);
			_result = 31 * _result + (internalTradeIdentifier != null ? internalTradeIdentifier.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionInformation {" +
				"tradableOnTradingVenue=" + this.tradableOnTradingVenue + ", " +
				"underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue + ", " +
				"underlierAssetTradingPlatformIdentifier=" + this.underlierAssetTradingPlatformIdentifier + ", " +
				"internalTradeIdentifier=" + this.internalTradeIdentifier +
			'}';
		}
	}

	/*********************** Builder Implementation of CommonTransactionInformation  ***********************/
	class CommonTransactionInformationBuilderImpl implements CommonTransactionInformation.CommonTransactionInformationBuilder {
	
		protected TradableOnTradingVenueEnum tradableOnTradingVenue;
		protected Boolean underlierTradedOnTradingVenue;
		protected String underlierAssetTradingPlatformIdentifier;
		protected String internalTradeIdentifier;
		
		@Override
		@RosettaAttribute("tradableOnTradingVenue")
		@RuneAttribute("tradableOnTradingVenue")
		public TradableOnTradingVenueEnum getTradableOnTradingVenue() {
			return tradableOnTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		public Boolean getUnderlierTradedOnTradingVenue() {
			return underlierTradedOnTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierAssetTradingPlatformIdentifier")
		@RuneAttribute("underlierAssetTradingPlatformIdentifier")
		public String getUnderlierAssetTradingPlatformIdentifier() {
			return underlierAssetTradingPlatformIdentifier;
		}
		
		@Override
		@RosettaAttribute("internalTradeIdentifier")
		@RuneAttribute("internalTradeIdentifier")
		public String getInternalTradeIdentifier() {
			return internalTradeIdentifier;
		}
		
		@RosettaAttribute("tradableOnTradingVenue")
		@RuneAttribute("tradableOnTradingVenue")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum _tradableOnTradingVenue) {
			this.tradableOnTradingVenue = _tradableOnTradingVenue == null ? null : _tradableOnTradingVenue;
			return this;
		}
		
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean _underlierTradedOnTradingVenue) {
			this.underlierTradedOnTradingVenue = _underlierTradedOnTradingVenue == null ? null : _underlierTradedOnTradingVenue;
			return this;
		}
		
		@RosettaAttribute("underlierAssetTradingPlatformIdentifier")
		@RuneAttribute("underlierAssetTradingPlatformIdentifier")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierAssetTradingPlatformIdentifier(String _underlierAssetTradingPlatformIdentifier) {
			this.underlierAssetTradingPlatformIdentifier = _underlierAssetTradingPlatformIdentifier == null ? null : _underlierAssetTradingPlatformIdentifier;
			return this;
		}
		
		@RosettaAttribute("internalTradeIdentifier")
		@RuneAttribute("internalTradeIdentifier")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder setInternalTradeIdentifier(String _internalTradeIdentifier) {
			this.internalTradeIdentifier = _internalTradeIdentifier == null ? null : _internalTradeIdentifier;
			return this;
		}
		
		@Override
		public CommonTransactionInformation build() {
			return new CommonTransactionInformation.CommonTransactionInformationImpl(this);
		}
		
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getTradableOnTradingVenue()!=null) return true;
			if (getUnderlierTradedOnTradingVenue()!=null) return true;
			if (getUnderlierAssetTradingPlatformIdentifier()!=null) return true;
			if (getInternalTradeIdentifier()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CommonTransactionInformation.CommonTransactionInformationBuilder o = (CommonTransactionInformation.CommonTransactionInformationBuilder) other;
			
			
			merger.mergeBasic(getTradableOnTradingVenue(), o.getTradableOnTradingVenue(), this::setTradableOnTradingVenue);
			merger.mergeBasic(getUnderlierTradedOnTradingVenue(), o.getUnderlierTradedOnTradingVenue(), this::setUnderlierTradedOnTradingVenue);
			merger.mergeBasic(getUnderlierAssetTradingPlatformIdentifier(), o.getUnderlierAssetTradingPlatformIdentifier(), this::setUnderlierAssetTradingPlatformIdentifier);
			merger.mergeBasic(getInternalTradeIdentifier(), o.getInternalTradeIdentifier(), this::setInternalTradeIdentifier);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(tradableOnTradingVenue, _that.getTradableOnTradingVenue())) return false;
			if (!Objects.equals(underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) return false;
			if (!Objects.equals(underlierAssetTradingPlatformIdentifier, _that.getUnderlierAssetTradingPlatformIdentifier())) return false;
			if (!Objects.equals(internalTradeIdentifier, _that.getInternalTradeIdentifier())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (tradableOnTradingVenue != null ? tradableOnTradingVenue.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlierTradedOnTradingVenue != null ? underlierTradedOnTradingVenue.hashCode() : 0);
			_result = 31 * _result + (underlierAssetTradingPlatformIdentifier != null ? underlierAssetTradingPlatformIdentifier.hashCode() : 0);
			_result = 31 * _result + (internalTradeIdentifier != null ? internalTradeIdentifier.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionInformationBuilder {" +
				"tradableOnTradingVenue=" + this.tradableOnTradingVenue + ", " +
				"underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue + ", " +
				"underlierAssetTradingPlatformIdentifier=" + this.underlierAssetTradingPlatformIdentifier + ", " +
				"internalTradeIdentifier=" + this.internalTradeIdentifier +
			'}';
		}
	}
}
