package drr.regulation.common;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.meta.RegimePartyInformationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * Specifies regime specific information required for reporting of the transaction
 * @version 7.0.0-dev.101
 */
@RosettaDataType(value="RegimePartyInformation", builder=RegimePartyInformation.RegimePartyInformationBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="RegimePartyInformation", model="drr", builder=RegimePartyInformation.RegimePartyInformationBuilderImpl.class, version="7.0.0-dev.101")
public interface RegimePartyInformation extends RosettaModelObject {

	RegimePartyInformationMeta metaData = new RegimePartyInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Specifies the party that is associated with the enriched information.
	 */
	ReferenceWithMetaParty getPartyReference();
	/**
	 * Specifies the regulatory regime requiring reporting of the transaction. A list of regime information is provided when an event is reportable to more than one regime.
	 */
	List<? extends ReportingRegime> getRegimeInformation();

	/*********************** Build Methods  ***********************/
	RegimePartyInformation build();
	
	RegimePartyInformation.RegimePartyInformationBuilder toBuilder();
	
	static RegimePartyInformation.RegimePartyInformationBuilder builder() {
		return new RegimePartyInformation.RegimePartyInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends RegimePartyInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends RegimePartyInformation> getType() {
		return RegimePartyInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.class, getPartyReference());
		processRosetta(path.newSubPath("regimeInformation"), processor, ReportingRegime.class, getRegimeInformation());
	}
	

	/*********************** Builder Interface  ***********************/
	interface RegimePartyInformationBuilder extends RegimePartyInformation, RosettaModelObjectBuilder {
		ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference();
		@Override
		ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference();
		ReportingRegime.ReportingRegimeBuilder getOrCreateRegimeInformation(int index);
		@Override
		List<? extends ReportingRegime.ReportingRegimeBuilder> getRegimeInformation();
		RegimePartyInformation.RegimePartyInformationBuilder setPartyReference(ReferenceWithMetaParty partyReference);
		RegimePartyInformation.RegimePartyInformationBuilder setPartyReferenceValue(Party partyReference);
		RegimePartyInformation.RegimePartyInformationBuilder addRegimeInformation(ReportingRegime regimeInformation);
		RegimePartyInformation.RegimePartyInformationBuilder addRegimeInformation(ReportingRegime regimeInformation, int idx);
		RegimePartyInformation.RegimePartyInformationBuilder addRegimeInformation(List<? extends ReportingRegime> regimeInformation);
		RegimePartyInformation.RegimePartyInformationBuilder setRegimeInformation(List<? extends ReportingRegime> regimeInformation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, getPartyReference());
			processRosetta(path.newSubPath("regimeInformation"), processor, ReportingRegime.ReportingRegimeBuilder.class, getRegimeInformation());
		}
		

		RegimePartyInformation.RegimePartyInformationBuilder prune();
	}

	/*********************** Immutable Implementation of RegimePartyInformation  ***********************/
	class RegimePartyInformationImpl implements RegimePartyInformation {
		private final ReferenceWithMetaParty partyReference;
		private final List<? extends ReportingRegime> regimeInformation;
		
		protected RegimePartyInformationImpl(RegimePartyInformation.RegimePartyInformationBuilder builder) {
			this.partyReference = ofNullable(builder.getPartyReference()).map(f->f.build()).orElse(null);
			this.regimeInformation = ofNullable(builder.getRegimeInformation()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="partyReference", isRequired=true)
		@RuneAttribute(value="partyReference", isRequired=true)
		public ReferenceWithMetaParty getPartyReference() {
			return partyReference;
		}
		
		@Override
		@RosettaAttribute(value="regimeInformation", isRequired=true)
		@RuneAttribute(value="regimeInformation", isRequired=true)
		public List<? extends ReportingRegime> getRegimeInformation() {
			return regimeInformation;
		}
		
		@Override
		public RegimePartyInformation build() {
			return this;
		}
		
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder toBuilder() {
			RegimePartyInformation.RegimePartyInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(RegimePartyInformation.RegimePartyInformationBuilder builder) {
			ofNullable(getPartyReference()).ifPresent(builder::setPartyReference);
			ofNullable(getRegimeInformation()).ifPresent(builder::setRegimeInformation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			RegimePartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(partyReference, _that.getPartyReference())) return false;
			if (!ListEquals.listEquals(regimeInformation, _that.getRegimeInformation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partyReference != null ? partyReference.hashCode() : 0);
			_result = 31 * _result + (regimeInformation != null ? regimeInformation.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "RegimePartyInformation {" +
				"partyReference=" + this.partyReference + ", " +
				"regimeInformation=" + this.regimeInformation +
			'}';
		}
	}

	/*********************** Builder Implementation of RegimePartyInformation  ***********************/
	class RegimePartyInformationBuilderImpl implements RegimePartyInformation.RegimePartyInformationBuilder {
	
		protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference;
		protected List<ReportingRegime.ReportingRegimeBuilder> regimeInformation = new ArrayList<>();
		
		@Override
		@RosettaAttribute(value="partyReference", isRequired=true)
		@RuneAttribute(value="partyReference", isRequired=true)
		public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference() {
			return partyReference;
		}
		
		@Override
		public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference() {
			ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result;
			if (partyReference!=null) {
				result = partyReference;
			}
			else {
				result = partyReference = ReferenceWithMetaParty.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="regimeInformation", isRequired=true)
		@RuneAttribute(value="regimeInformation", isRequired=true)
		public List<? extends ReportingRegime.ReportingRegimeBuilder> getRegimeInformation() {
			return regimeInformation;
		}
		
		@Override
		public ReportingRegime.ReportingRegimeBuilder getOrCreateRegimeInformation(int index) {
			if (regimeInformation==null) {
				this.regimeInformation = new ArrayList<>();
			}
			return getIndex(regimeInformation, index, () -> {
						ReportingRegime.ReportingRegimeBuilder newRegimeInformation = ReportingRegime.builder();
						return newRegimeInformation;
					});
		}
		
		@RosettaAttribute(value="partyReference", isRequired=true)
		@RuneAttribute(value="partyReference", isRequired=true)
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder setPartyReference(ReferenceWithMetaParty _partyReference) {
			this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
			return this;
		}
		
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder setPartyReferenceValue(Party _partyReference) {
			this.getOrCreatePartyReference().setValue(_partyReference);
			return this;
		}
		
		@RosettaAttribute(value="regimeInformation", isRequired=true)
		@RuneAttribute(value="regimeInformation", isRequired=true)
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder addRegimeInformation(ReportingRegime _regimeInformation) {
			if (_regimeInformation != null) {
				this.regimeInformation.add(_regimeInformation.toBuilder());
			}
			return this;
		}
		
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder addRegimeInformation(ReportingRegime _regimeInformation, int idx) {
			getIndex(this.regimeInformation, idx, () -> _regimeInformation.toBuilder());
			return this;
		}
		
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder addRegimeInformation(List<? extends ReportingRegime> regimeInformations) {
			if (regimeInformations != null) {
				for (final ReportingRegime toAdd : regimeInformations) {
					this.regimeInformation.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("regimeInformation")
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder setRegimeInformation(List<? extends ReportingRegime> regimeInformations) {
			if (regimeInformations == null) {
				this.regimeInformation = new ArrayList<>();
			} else {
				this.regimeInformation = regimeInformations.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		public RegimePartyInformation build() {
			return new RegimePartyInformation.RegimePartyInformationImpl(this);
		}
		
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder prune() {
			if (partyReference!=null && !partyReference.prune().hasData()) partyReference = null;
			regimeInformation = regimeInformation.stream().filter(b->b!=null).<ReportingRegime.ReportingRegimeBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPartyReference()!=null && getPartyReference().hasData()) return true;
			if (getRegimeInformation()!=null && getRegimeInformation().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public RegimePartyInformation.RegimePartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			RegimePartyInformation.RegimePartyInformationBuilder o = (RegimePartyInformation.RegimePartyInformationBuilder) other;
			
			merger.mergeRosetta(getPartyReference(), o.getPartyReference(), this::setPartyReference);
			merger.mergeRosetta(getRegimeInformation(), o.getRegimeInformation(), this::getOrCreateRegimeInformation);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			RegimePartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(partyReference, _that.getPartyReference())) return false;
			if (!ListEquals.listEquals(regimeInformation, _that.getRegimeInformation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partyReference != null ? partyReference.hashCode() : 0);
			_result = 31 * _result + (regimeInformation != null ? regimeInformation.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "RegimePartyInformationBuilder {" +
				"partyReference=" + this.partyReference + ", " +
				"regimeInformation=" + this.regimeInformation +
			'}';
		}
	}
}
