package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(FilterPartyInformationBySupervisoryBody.FilterPartyInformationBySupervisoryBodyDefault.class)
public abstract class FilterPartyInformationBySupervisoryBody implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param regimePartyInformation 
	* @param jurisdiction 
	* @return filteredPartyInformation 
	*/
	public List<? extends RegimePartyInformation> evaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum jurisdiction) {
		List<RegimePartyInformation.RegimePartyInformationBuilder> filteredPartyInformationBuilder = doEvaluate(regimePartyInformation, jurisdiction);
		
		final List<? extends RegimePartyInformation> filteredPartyInformation;
		if (filteredPartyInformationBuilder == null) {
			filteredPartyInformation = null;
		} else {
			filteredPartyInformation = filteredPartyInformationBuilder.stream().map(RegimePartyInformation::build).collect(Collectors.toList());
			objectValidator.validate(RegimePartyInformation.class, filteredPartyInformation);
		}
		
		return filteredPartyInformation;
	}

	protected abstract List<RegimePartyInformation.RegimePartyInformationBuilder> doEvaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum jurisdiction);

	public static class FilterPartyInformationBySupervisoryBodyDefault extends FilterPartyInformationBySupervisoryBody {
		@Override
		protected List<RegimePartyInformation.RegimePartyInformationBuilder> doEvaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum jurisdiction) {
			if (regimePartyInformation == null) {
				regimePartyInformation = Collections.emptyList();
			}
			List<RegimePartyInformation.RegimePartyInformationBuilder> filteredPartyInformation = new ArrayList<>();
			return assignOutput(filteredPartyInformation, regimePartyInformation, jurisdiction);
		}
		
		protected List<RegimePartyInformation.RegimePartyInformationBuilder> assignOutput(List<RegimePartyInformation.RegimePartyInformationBuilder> filteredPartyInformation, List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum jurisdiction) {
			filteredPartyInformation.addAll(toBuilder(MapperC.<RegimePartyInformation>of(regimePartyInformation)
				.filterItemNullSafe(item -> areEqual(item.<ReportingRegime>mapC("getRegimeInformation", _regimePartyInformation -> _regimePartyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(jurisdiction), CardinalityOperator.Any).get()).getMulti()));
			
			return Optional.ofNullable(filteredPartyInformation)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
