package drr.regulation.common.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.TradableOnTradingVenueEnum;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CommonTransactionInformationValidator implements Validator<CommonTransactionInformation> {

	private List<ComparisonResult> getComparisonResults(CommonTransactionInformation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("tradableOnTradingVenue", (TradableOnTradingVenueEnum) o.getTradableOnTradingVenue() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierTradedOnTradingVenue", (Boolean) o.getUnderlierTradedOnTradingVenue() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierAssetTradingPlatformIdentifier", (String) o.getUnderlierAssetTradingPlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("internalTradeIdentifier", (String) o.getInternalTradeIdentifier() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommonTransactionInformation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CommonTransactionInformation", ValidationResult.ValidationType.CARDINALITY, "CommonTransactionInformation", path, "", res.getError());
				}
				return success("CommonTransactionInformation", ValidationResult.ValidationType.CARDINALITY, "CommonTransactionInformation", path, "");
			})
			.collect(toList());
	}

}
