package drr.regulation.common.validation;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportingRegime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class RegimePartyInformationValidator implements Validator<RegimePartyInformation> {

	private List<ComparisonResult> getComparisonResults(RegimePartyInformation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("partyReference", (ReferenceWithMetaParty) o.getPartyReference() != null ? 1 : 0, 1, 1), 
				checkCardinality("regimeInformation", (List<? extends ReportingRegime>) o.getRegimeInformation() == null ? 0 : o.getRegimeInformation().size(), 1, 0)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, RegimePartyInformation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("RegimePartyInformation", ValidationResult.ValidationType.CARDINALITY, "RegimePartyInformation", path, "", res.getError());
				}
				return success("RegimePartyInformation", ValidationResult.ValidationType.CARDINALITY, "RegimePartyInformation", path, "");
			})
			.collect(toList());
	}

}
