package drr.regulation.common.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.DeliveryCapacity;
import drr.standards.iso.EnergyQuantityUnit2Code;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class DeliveryCapacityOnlyExistsValidator implements ValidatorWithArg<DeliveryCapacity, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends DeliveryCapacity> ValidationResult<DeliveryCapacity> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("amount", ExistenceChecker.isSet((BigDecimal) o.getAmount()))
				.put("unit", ExistenceChecker.isSet((EnergyQuantityUnit2Code) o.getUnit()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("DeliveryCapacity", ValidationResult.ValidationType.ONLY_EXISTS, "DeliveryCapacity", path, "");
		}
		return failure("DeliveryCapacity", ValidationResult.ValidationType.ONLY_EXISTS, "DeliveryCapacity", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
