package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ExecutionVenueTypeEnum;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ExecutionVenueTypeRule.ExecutionVenueTypeRuleDefault.class)
public abstract class ExecutionVenueTypeRule implements ReportFunction<TransactionReportInstruction, ExecutionVenueTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ExecutionVenueTypeEnum evaluate(TransactionReportInstruction input) {
		ExecutionVenueTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ExecutionVenueTypeEnum doEvaluate(TransactionReportInstruction input);

	public static class ExecutionVenueTypeRuleDefault extends ExecutionVenueTypeRule {
		@Override
		protected ExecutionVenueTypeEnum doEvaluate(TransactionReportInstruction input) {
			ExecutionVenueTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ExecutionVenueTypeEnum assignOutput(ExecutionVenueTypeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<ReportableInformation> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
			output = thenArg1
				.mapSingleToItem(item -> {
					final MapperC<RegimePartyInformation> thenArg = item.<RegimePartyInformation>mapC("getRegimePartyInformation", reportableInformation -> reportableInformation.getRegimePartyInformation())
						.filterItemNullSafe(_item -> areEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), _item.<ReportingRegime>mapC("getRegimeInformation", regimePartyInformation -> regimePartyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), CardinalityOperator.Any).get());
					if (exists(thenArg).asMapper().getOrDefault(false)) {
						return item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType());
					}
					return MapperS.<ExecutionVenueTypeEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
