package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.qualification.product.functions.IsFRA;
import drr.base.qualification.product.functions.IsIRSwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.base.trade.underlier.functions.UnderlierProductIdentifier;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetIndexIndicatorFromFloatingRate;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iso.IndexEnum;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(UnderlyingIndexIndicatorRule.UnderlyingIndexIndicatorRuleDefault.class)
public abstract class UnderlyingIndexIndicatorRule implements ReportFunction<TransactionReportInstruction, List<IndexEnum>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetIndexIndicatorFromFloatingRate getIndexIndicatorFromFloatingRate;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsFRA isFRA;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected UnderlierForProduct underlierForProduct;
	@Inject protected UnderlierProductIdentifier underlierProductIdentifier;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<IndexEnum> evaluate(TransactionReportInstruction input) {
		List<IndexEnum> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<IndexEnum> doEvaluate(TransactionReportInstruction input);

	public static class UnderlyingIndexIndicatorRuleDefault extends UnderlyingIndexIndicatorRule {
		@Override
		protected List<IndexEnum> doEvaluate(TransactionReportInstruction input) {
			List<IndexEnum> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<IndexEnum> assignOutput(List<IndexEnum> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (ComparisonResult.ofNullSafe(MapperS.of(isCreditSwaption.evaluate(productForEvent.evaluate(item.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isIRSwaption.evaluate(productForEvent.evaluate(item.get()))))).getOrDefault(false)) {
						return MapperS.of(underlierForProduct.evaluate(productForEvent.evaluate(item.get())));
					}
					return MapperS.of(productForEvent.evaluate(item.get()));
				});
			final MapperC<String> thenArg2 = thenArg1
				.mapSingleToList(item -> {
					final Boolean boolean0 = isFRA.evaluate(item.get());
					final MapperS<String> ifThenElseResult;
					if ((boolean0 == null ? false : boolean0)) {
						ifThenElseResult = item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex())
							.first().<FloatingRateIndexEnum>map("Type coercion", fieldWithMetaFloatingRateIndexEnum0 -> fieldWithMetaFloatingRateIndexEnum0 == null ? null : fieldWithMetaFloatingRateIndexEnum0.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString);
					} else {
						final Boolean boolean1 = qualify_BaseProduct_IRSwap.evaluate(economicTermsForProduct.evaluate(item.get()));
						if ((boolean1 == null ? false : boolean1)) {
							ifThenElseResult = MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex())
								.first().<FloatingRateIndexEnum>map("Type coercion", fieldWithMetaFloatingRateIndexEnum1 -> fieldWithMetaFloatingRateIndexEnum1 == null ? null : fieldWithMetaFloatingRateIndexEnum1.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString);
						} else {
							ifThenElseResult = MapperS.<String>ofNull();
						}
					}
					return MapperC.<ProductIdentifier>of(underlierProductIdentifier.evaluate(item.get(), ProductIdTypeEnum.NAME)).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti().isEmpty() ? MapperC.of(ifThenElseResult) : MapperC.<ProductIdentifier>of(underlierProductIdentifier.evaluate(item.get(), ProductIdTypeEnum.NAME)).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
				});
			output = thenArg2
				.mapItem(item -> MapperS.of(getIndexIndicatorFromFloatingRate.evaluate(item.get()))).getMulti();
			
			return output;
		}
	}
}
