package drr.regulation.sec.rewrite.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class SECTradeLabelProvider extends GraphBasedLabelProvider {
	public SECTradeLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("effectiveDate"), "901.c.1.ii CDE - Effective Date");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "Reporting timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "901.c.2 Original Execution Timestamp");
		startNode.addLabel(Arrays.asList("expirationDate"), "901.c.1.ii CDE - Expiration date");
		startNode.addLabel(Arrays.asList("counterparty1"), "13 Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "901.d.1 Trade Party 2 - ID");
		startNode.addLabel(Arrays.asList("buyerIdentifier"), "901.d.5 Buyer / Payer 1");
		startNode.addLabel(Arrays.asList("sellerIdentifier"), "901.d.5 Seller / Payer 2");
		startNode.addLabel(Arrays.asList("cleared"), "901.c.6 Clearing Status");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "901.c.6; 901.d.6 Clearing Venue - ID");
		startNode.addLabel(Arrays.asList("clearingMember"), "Trade Party 1 - Clearing Broker ID");
		startNode.addLabel(Arrays.asList("callAmount"), "86 Call amount");
		startNode.addLabel(Arrays.asList("putAmount"), "87 Put Amount");
		startNode.addLabel(Arrays.asList("callCurrency"), "90 Call currency");
		startNode.addLabel(Arrays.asList("putCurrency"), "91 Put currency");
		startNode.addLabel(Arrays.asList("price"), "901.c.3 Price 1 - Price");
		startNode.addLabel(Arrays.asList("priceNotation"), "901.c.3 CDE - Price Notation");
		startNode.addLabel(Arrays.asList("priceCurrency"), "901.c.3 CDE - Price Currency");
		startNode.addLabel(Arrays.asList("packageTransactionPrice"), "901.d.5 CDE - Package Transaction Price");
		startNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "901.d.5 CDE - Package Transaction Price Notation");
		startNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "901.d.5 CDE - Package Transaction Price Currency");
		startNode.addLabel(Arrays.asList("packageTransactionSpread"), "901.d.5 CDE - Package Transaction Spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "901.d.5 CDE - Package Transaction Spread Notation");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "901.d.5 CDE - Package Transaction Spread Currency");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "901.d.5 CDE - Package Identifier");
		startNode.addLabel(Arrays.asList("strikePrice"), "901.c.3 Strike Price");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "901.c.3 CDE - Strike Price notation");
		startNode.addLabel(Arrays.asList("strikePriceCurrency"), "901.c.3 Strike Price - Currency");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "901.c.3 Price 1 - Units");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "901.c.3 Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "901.c.3 Premium Currency");
		startNode.addLabel(Arrays.asList("optionPremiumPaymentDate"), "901.c.3 Premium Payment Date Unadjusted");
		startNode.addLabel(Arrays.asList("cdSIndexAttachmentPoint"), "901.d.5 Attachment Point");
		startNode.addLabel(Arrays.asList("cdSIndexDetachmentPoint"), "901.d.5 Exhaustion Point");
		startNode.addLabel(Arrays.asList("firstExerciseDate"), "901.c.1.iii CDE - First exercise date");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "901.d.8 CDE - Final Contractual Settlement Date");
		startNode.addLabel(Arrays.asList("settlementLocation"), "901.d.8 CDE - Settlement location-Leg 1");
		startNode.addLabel(Arrays.asList("priorUTI"), "901.g, 901.d.10 Prior UTI ID");
		startNode.addLabel(Arrays.asList("otherPayment", "paymentType"), "901.d.3 (901.c.3?) CDE - Other Payment Type");
		startNode.addLabel(Arrays.asList("otherPayment", "amount"), "901.c.3 CDE - Other Payment Amount");
		startNode.addLabel(Arrays.asList("otherPayment", "currency"), "901.c.3 CDE - Other Payment Currency");
		startNode.addLabel(Arrays.asList("otherPayment", "date"), "901.c.1.iv CDE - Other Payment Date");
		startNode.addLabel(Arrays.asList("otherPayment", "payer"), "901.d.5 CDE - Other Payment Payer");
		startNode.addLabel(Arrays.asList("otherPayment", "receiver"), "901.d.5 CDE - Other Payment Receiver");
		startNode.addLabel(Arrays.asList("leg1", "payerIdentifier"), "901.d.5 Payment 1 - Payer");
		startNode.addLabel(Arrays.asList("leg1", "receiverIdentifier"), "901.d.5 Payment 1 - Receiver");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmount"), "901.c.4 Notional Amount 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalCurrency"), "901.c.4 Notional Currency 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "value"), "901.c.4 CDE - Notional amount in effect on associated effective date - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "effectiveDate"), "901.c.4 CDE - Effective date of the notional amount - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "endDate"), "901.c.4 CDE - End date of the notional amount - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityUnitOfMeasure"), "901.d.5 CDE - Quantity unit of measure - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "totalNotionalQuantity"), "901.d.5 Leg 1 - Total Notional Quantity");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRateDayCountConvention"), "901.d.3 CDE - Fixed rate day count convention - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateDayCountConvention"), "901.d.3 CDE - Floating rate day count convention- Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixingDate"), "901.d.3 Fixing Date- Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyPeriod"), "901.d.3 Reset Frequency Period 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "901.d.3 Reset Frequency Period Multiplier 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "901.d.3 CDE - Fixed rate payment frequency period - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "901.d.3 CDE - Floating rate payment frequency period - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "901.d.3 CDE - Fixed rate payment frequency period multiplier - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "901.d.3 CDE - Floating rate payment frequency period multiplier - Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixedRate"), "901.d.3 Leg 1 - Fixed Rate Initial");
		startNode.addLabel(Arrays.asList("leg1", "spread"), "901.c.3 Leg 1 - Spread Amount");
		startNode.addLabel(Arrays.asList("leg1", "spreadCurrency"), "901.c.3 Leg 1 - Spread Currency");
		startNode.addLabel(Arrays.asList("leg1", "spreadNotation"), "901.c.3 CDE - Spread notation-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "settlementCurrency"), "901.d.8 Settlement Currency 1");
		startNode.addLabel(Arrays.asList("leg2", "payerIdentifier"), "901.d.5 Payment 2 - Payer");
		startNode.addLabel(Arrays.asList("leg2", "receiverIdentifier"), "901.d.5 CDE - Receiver Identifier - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmount"), "901.c.4 Notional Amount 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalCurrency"), "901.c.4 Notional Currency 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "value"), "901.c.4 CDE - Notional amount in effect on associated effective date - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "effectiveDate"), "901.c.4 CDE - Effective date of the notional amount - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "endDate"), "901.c.4 CDE - End date of the notional amount - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityUnitOfMeasure"), "901.d.5 CDE - Quantity unit of measure - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "totalNotionalQuantity"), "901.d.5 Leg 2 - Total Notional Quantity");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRateDayCountConvention"), "901.d.3 CDE - Fixed rate day count convention - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateDayCountConvention"), "901.d.3 CDE - Floating rate day count convention - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixingDate"), "901.d.3 Fixing date - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyPeriod"), "901.d.3 Leg 2 - Reset Frequency Period");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "901.d.3 Leg 2 - Reset Frequency Period Multiplier");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "901.d.3 CDE - Fixed rate payment frequency period - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "901.d.3 CDE - Floating rate payment frequency period - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "901.d.3 CDE - Fixed rate payment frequency period multiplier - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "901.d.3 CDE - Floating rate payment frequency period multiplier - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixedRate"), "901.d.3 Leg 2 - Fixed Rate Initial");
		startNode.addLabel(Arrays.asList("leg2", "spread"), "901.c.3 Leg 2 - Spread Amount");
		startNode.addLabel(Arrays.asList("leg2", "spreadCurrency"), "901.c.3 Leg 2 - Spread Currency");
		startNode.addLabel(Arrays.asList("leg2", "spreadNotation"), "901.c.3 CDE - Spread notation - Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "settlementCurrency"), "901.d.8 Leg 2 - Settlement Currency");
		startNode.addLabel(Arrays.asList("actionType"), "NoA - Action Type");
		startNode.addLabel(Arrays.asList("eventType"), "Event Type");
		startNode.addLabel(Arrays.asList("eventIdentifier"), "Event Identifier");
		startNode.addLabel(Arrays.asList("eventTimestamp"), "901.e.1.i; 901.c.2 Latest Execution DateTime");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "901.d.9 CDE - Platform identifier");
		startNode.addLabel(Arrays.asList("clearingExceptionsAndExemptionsCounterparty1"), "901.d.7 Clearing Exception Type");
		startNode.addLabel(Arrays.asList("clearingExceptionsAndExemptionsCounterparty2"), "901.d.7 Clearing exceptions and exemptions - Counterparty 2");
		startNode.addLabel(Arrays.asList("reportSubmittingEntityID"), "13n\u20135(b)(1)(iii) Submitting Party ID");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierSource"), "901.d.1 Trade Party 2 - ID Type");
		startNode.addLabel(Arrays.asList("embeddedOptionType"), "901.c.1 Embedded Option on Swap");
		startNode.addLabel(Arrays.asList("nonStandardizedTermIndicator"), "907.a.4 Non Standard Trade Indicator");
		startNode.addLabel(Arrays.asList("amendmentIndicator"), "Amendment Indicator");
		startNode.addLabel(Arrays.asList("packageIndicator"), "901.d.5 Package Indicator");
		startNode.addLabel(Arrays.asList("customBasketIndicator"), "901.c.1.v Custom Basket Indicator");
		startNode.addLabel(Arrays.asList("clearingAccountOrigin"), "Origin");
		startNode.addLabel(Arrays.asList("clearingReceiptTimestamp"), "901.e.1.ii Clearing Receipt DateTime");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "901.g UTI ID");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "901.c.1 UPI");
		startNode.addLabel(Arrays.asList("originalSwapUTI"), "901.g Original Swap UTI");
		startNode.addLabel(Arrays.asList("originalSwapSDRIdentifier"), "Original Swap SDR - ID");
		startNode.addLabel(Arrays.asList("priorUSI"), "901.g, 901.d.10 Prior USI ID");
		startNode.addLabel(Arrays.asList("newSDRIdentifier"), "New SDR Identifier");
		startNode.addLabel(Arrays.asList("indexFactor"), "901.c.1 Index Factor");
		startNode.addLabel(Arrays.asList("nonReportable", "enrichment"), "Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "preUpiData"), "Upi Pre-Enrichment Data");
		startNode.addLabel(Arrays.asList("nonReportable", "postUpiData"), "Upi Post-Enrichment Data");
		startNode.addLabel(Arrays.asList("clearingSwapUSIs"), "901.g Clearing Swap USI ID");
		startNode.addLabel(Arrays.asList("clearingSwapUTIs"), "901.g Clearing Swap UTI ID");
		startNode.addLabel(Arrays.asList("originalSwapUSI"), "901.g Original Swap USI");
		startNode.addLabel(Arrays.asList("postPricedSwapIndicator"), "Post-priced swap indicator");
		startNode.addLabel(Arrays.asList("allocationIndicator"), "902.c.7 Allocation Type");
		startNode.addLabel(Arrays.asList("uniqueSwapIdentifier"), "901.g USI ID");
		startNode.addLabel(Arrays.asList("counterparty1FinancialEntityIndicator"), "16 Trade Party 1 - CFTC Financial Entity Status");
		startNode.addLabel(Arrays.asList("counterparty2FinancialEntityIndicator"), "17 Trade Party 2 - CFTC Financial Entity Status");
		startNode.addLabel(Arrays.asList("jurisdiction"), "Swap Reporting Jurisdiction");
		
		LabelNode dTCCAdditionalFieldsNode = new LabelNode();
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("clearingVenueIDType"), "901.c.6; 901.d.6 Clearing Venue - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1ClearingBrokerIDType"), "Trade Party 1 - Clearing Broker ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("submittingPartyIDType"), "Submitting Party - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("submittedForParty"), "Submitted For Party");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1ReportingDestination"), "Trade Party 1 - Reporting Destination");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty2ReportingDestination"), "Trade Party 2 - Reporting Destination");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("primaryAssetClass"), "Primary Asset Class");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("secondaryAssetClass"), "Secondary Asset Class");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("comment1"), "Comment 1");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty2ExecutionAgentID"), "Trade Party 2 - Execution Agent ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty2ExecutionAgentIDType"), "Trade Party 2 - Execution Agent ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1ExecutionAgentID"), "Trade Party 1 - Execution Agent ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1ExecutionAgentIDType"), "Trade Party 1 - Execution Agent ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1TransactionID"), "Trade Party 1 - Transaction ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("responsibleDataSubmitterIDType"), "Responsible Data Submitter - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("responsibleDataSubmitterID"), "Responsible Data Submitter - ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("maturityDateOfTheUnderlying"), "901.c.1.iii Maturity Date of the Underlier");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("corporateActionNewTradeParty1Lei"), "Corporate Action - New Trade Party 1 LEI");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("otherPaymentPayerIDType"), "Other Payment Payer ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("otherPaymentReceiverIDType"), "Other Payment Receiver ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("sefOrDcmAnonymousExecutionIndicator"), "SEF or DCM Anonymous Execution Indicator");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("executionVenueID"), "901.d.9 Execution Venue - ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("executionVenueIDType"), "901.d.9 Execution Venue - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg1FloatingRateIndex"), "901.d.3 Leg 1 - Floating Rate Index");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("leg2FloatingRateIndex"), "901.d.3 Leg 2 - Floating Rate Index");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("underlyingAssetName"), "901.c.1.v Underlying Asset Name");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("underlyingAsset", "underlyingAssetID"), "901.c.1.v Underlying Asset ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("underlyingAsset", "underlyingAssetIDType"), "901.c.1.v Underlying Asset ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("originalSwapSDRIDType"), "Original Swap SDR - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("tradeParty1IDType"), "901.d.1 Trade Party 1 - ID Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("messageID"), "Message ID");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("messageType"), "Message Type");
		dTCCAdditionalFieldsNode.addLabel(Arrays.asList("version"), "Version");
		
		startNode.addOutgoingEdge("dtccAdditionalFields", dTCCAdditionalFieldsNode);
	}
}
