/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.Property;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicProperty;
import org.joda.convert.StringConvert;

public interface MetaProperty<P> {
    default public Property<P> createProperty(Bean bean) {
        return BasicProperty.of(bean, this);
    }

    public MetaBean metaBean();

    public String name();

    public Class<?> declaringType();

    public Class<P> propertyType();

    public Type propertyGenericType();

    public PropertyStyle style();

    public List<Annotation> annotations();

    default public <A extends Annotation> A annotation(Class<A> annotationClass) {
        List<Annotation> annotations = this.annotations();
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        throw new NoSuchElementException("Unknown annotation: " + annotationClass.getName());
    }

    public P get(Bean var1);

    public void set(Bean var1, Object var2);

    default public P put(Bean bean, Object value) {
        P old = this.get(bean);
        this.set(bean, value);
        return old;
    }

    default public String getString(Bean bean) {
        return this.getString(bean, JodaBeanUtils.stringConverter());
    }

    default public String getString(Bean bean, StringConvert stringConvert) {
        P value = this.get(bean);
        return stringConvert.convertToString(this.propertyType(), value);
    }

    default public void setString(Bean bean, String value) {
        this.setString(bean, value, JodaBeanUtils.stringConverter());
    }

    default public void setString(Bean bean, String value, StringConvert stringConvert) {
        this.set(bean, stringConvert.convertFromString(this.propertyType(), value));
    }

    public boolean equals(Object var1);

    public int hashCode();
}

