/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.config.file;

import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Provider;

public class RosettaConfigurationFileProvider
implements jakarta.inject.Provider<URL>,
Provider<URL> {
    public static final String FILE_NAME = "rosetta-config.yml";
    private final String fileName;
    private final boolean loadFromClasspath;

    public static RosettaConfigurationFileProvider createFromFile(String fileName) {
        return new RosettaConfigurationFileProvider(false, fileName);
    }

    @Inject
    public RosettaConfigurationFileProvider() {
        this(true, FILE_NAME);
    }

    private RosettaConfigurationFileProvider(boolean loadFromClasspath, String fileName) {
        this.loadFromClasspath = loadFromClasspath;
        this.fileName = fileName;
    }

    public URL get() {
        if (this.loadFromClasspath) {
            return Thread.currentThread().getContextClassLoader().getResource(this.fileName);
        }
        return this.getUrlForFile();
    }

    private URL getUrlForFile() {
        try {
            Path path = Path.of(this.fileName, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path)) {
                return path.toUri().toURL();
            }
            throw new IllegalStateException("Configuration file " + String.valueOf(path.toAbsolutePath()) + " does not exist or is not a regular file.");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Bad configuration filename " + this.fileName, e);
        }
    }
}

