/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.regnosys.rosetta.formatting2.AbstractRosettaFormatter2;
import com.regnosys.rosetta.formatting2.FormattingMode;
import com.regnosys.rosetta.formatting2.FormattingUtil;
import com.regnosys.rosetta.formatting2.RosettaFormatterPreferenceKeys;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseOrDefault;
import com.regnosys.rosetta.rosetta.expression.SwitchOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.WithMetaEntry;
import com.regnosys.rosetta.rosetta.expression.WithMetaOperation;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class RosettaExpressionFormatter
extends AbstractRosettaFormatter2 {
    @Inject
    @Extension
    private RosettaGrammarAccess _rosettaGrammarAccess;
    @Inject
    @Extension
    private FormattingUtil _formattingUtil;

    private boolean isSimple(RosettaExpression expr) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (expr instanceof RosettaLiteral) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && expr instanceof RosettaImplicitVariable) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && expr instanceof RosettaSymbolReference) {
            _matched = true;
            boolean _isExplicitArguments = ((RosettaSymbolReference)expr).isExplicitArguments();
            boolean bl = _switchResult = !_isExplicitArguments;
        }
        if (!_matched && expr instanceof RosettaFeatureCall) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && expr instanceof ArithmeticOperation) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && expr instanceof ComparisonOperation) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    private boolean shouldBeOnSingleLine(RosettaExpression expr) {
        boolean _xblockexpression = false;
        boolean _isSimple = this.isSimple(expr);
        if (_isSimple) {
            return true;
        }
        boolean _switchResult = false;
        boolean _matched = false;
        if (expr instanceof RosettaBinaryOperation) {
            _matched = true;
            boolean bl = _switchResult = this.isSimple(((RosettaBinaryOperation)expr).getLeft()) || this.isSimple(((RosettaBinaryOperation)expr).getRight());
        }
        if (!_matched && expr instanceof RosettaFunctionalOperation) {
            _matched = true;
            boolean bl = _switchResult = ((RosettaFunctionalOperation)expr).getFunction() == null && this.isSimple(((RosettaFunctionalOperation)expr).getArgument());
        }
        if (!_matched && expr instanceof RosettaUnaryOperation) {
            _matched = true;
            _switchResult = this.isSimple(((RosettaUnaryOperation)expr).getArgument());
        }
        if (!_matched && expr instanceof ListLiteral) {
            _matched = true;
            Functions.Function1 _function = it -> this.isSimple((RosettaExpression)it);
            _switchResult = IterableExtensions.forall(((ListLiteral)expr).getElements(), (Functions.Function1)_function);
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private boolean isEmpty(RosettaExpression expr) {
        return expr == null || expr.isGenerated();
    }

    public void initialize(FormatterRequest request) {
        super.initialize(request);
    }

    public void format(Object obj, IFormattableDocument document) {
        boolean _matched = false;
        if (obj instanceof RosettaExpression) {
            _matched = true;
            this.formatExpression((RosettaExpression)obj, document);
        }
        if (!_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(RosettaExpressionFormatter.class);
            _builder.append(" does not support formatting ");
            _builder.append(obj);
            _builder.append(".");
            throw new UnsupportedOperationException(_builder.toString());
        }
    }

    public void formatExpression(RosettaExpression expr, IFormattableDocument document) {
        this.formatExpression(expr, document, FormattingMode.NORMAL);
    }

    public void formatExpression(RosettaExpression expr, @Extension IFormattableDocument document, FormattingMode mode) {
        boolean _not;
        boolean _isGenerated = expr.isGenerated();
        boolean bl = _not = !_isGenerated;
        if (_not) {
            ISemanticRegion leftParenthesis = this.textRegionExtensions.regionFor((EObject)expr).keyword(this._rosettaGrammarAccess.getPrimaryExpressionAccess().getLeftParenthesisKeyword_7_0());
            ISemanticRegion rightParenthesis = this.textRegionExtensions.regionFor((EObject)expr).keyword(this._rosettaGrammarAccess.getPrimaryExpressionAccess().getRightParenthesisKeyword_7_2());
            if (leftParenthesis != null && rightParenthesis != null) {
                boolean _not_1;
                Procedures.Procedure1 _function = it -> it.noSpace();
                document.append(leftParenthesis, _function);
                Procedures.Procedure1 _function_1 = it -> it.noSpace();
                document.prepend(rightParenthesis, _function_1);
                boolean _isMultiline = this.textRegionExtensions.isMultiline((EObject)expr);
                boolean bl2 = _not_1 = !_isMultiline;
                if (_not_1) {
                    this.unsafeFormatExpression(expr, document, FormattingMode.SINGLE_LINE);
                } else {
                    this.unsafeFormatExpression(expr, document, mode.stopChain());
                }
            } else {
                this.unsafeFormatExpression(expr, document, mode);
            }
        }
    }

    private void _unsafeFormatExpression(WithMetaOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        RosettaGrammarAccess.UnaryOperationElements unaryOperationGrammarAccess = this._rosettaGrammarAccess.getUnaryOperationAccess();
        Procedures.Procedure1 _function = it -> {};
        this.formatUnaryOperation(expr, document, mode, (Procedures.Procedure1<? super IFormattableDocument>)_function);
        Keyword _leftCurlyBracketKeyword_0_1_0_0_23_2_0 = unaryOperationGrammarAccess.getLeftCurlyBracketKeyword_0_1_0_0_23_2_0();
        Keyword _leftCurlyBracketKeyword_1_0_0_21_2_0 = unaryOperationGrammarAccess.getLeftCurlyBracketKeyword_1_0_0_21_2_0();
        Keyword _leftCurlyBracketKeyword_1_1_0_0_23_2_0 = unaryOperationGrammarAccess.getLeftCurlyBracketKeyword_1_1_0_0_23_2_0();
        Functions.Function1 _function_1 = it -> {
            ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)expr).keyword(it);
            return _keyword != null;
        };
        Keyword leftCurlyBracketKeyword = (Keyword)IterableExtensions.findFirst(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_leftCurlyBracketKeyword_0_1_0_0_23_2_0, _leftCurlyBracketKeyword_1_0_0_21_2_0, _leftCurlyBracketKeyword_1_1_0_0_23_2_0})), (Functions.Function1)_function_1);
        Keyword _rightCurlyBracketKeyword_0_1_0_0_23_2_2 = unaryOperationGrammarAccess.getRightCurlyBracketKeyword_0_1_0_0_23_2_2();
        Keyword _rightCurlyBracketKeyword_1_0_0_21_2_2 = unaryOperationGrammarAccess.getRightCurlyBracketKeyword_1_0_0_21_2_2();
        Keyword _rightCurlyBracketKeyword_1_1_0_0_23_2_2 = unaryOperationGrammarAccess.getRightCurlyBracketKeyword_1_1_0_0_23_2_2();
        Functions.Function1 _function_2 = it -> {
            ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)expr).keyword(it);
            return _keyword != null;
        };
        Keyword rightCurlyBracketKeyword = (Keyword)IterableExtensions.findFirst(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Keyword[]{_rightCurlyBracketKeyword_0_1_0_0_23_2_2, _rightCurlyBracketKeyword_1_0_0_21_2_2, _rightCurlyBracketKeyword_1_1_0_0_23_2_2})), (Functions.Function1)_function_2);
        this.constructorLikeFormat(expr, document, mode, leftCurlyBracketKeyword, rightCurlyBracketKeyword);
    }

    private void _unsafeFormatExpression(RosettaConstructorExpression expr, @Extension IFormattableDocument document, FormattingMode mode) {
        RosettaGrammarAccess.ConstructorExpressionElements constructorGrammarAccess = this._rosettaGrammarAccess.getConstructorExpressionAccess();
        this.constructorLikeFormat(expr, document, mode, constructorGrammarAccess.getLeftCurlyBracketKeyword_2(), constructorGrammarAccess.getRightCurlyBracketKeyword_4());
    }

    private void constructorLikeFormat(RosettaExpression expr, @Extension IFormattableDocument document, FormattingMode mode, Keyword leftCurlyBracket, Keyword rightCurlyBracket) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        this.interiorIndentWithoutCurlyBracket(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(leftCurlyBracket), _function), _function_1), this.textRegionExtensions.regionFor((EObject)expr).keyword(rightCurlyBracket), document);
        ISemanticRegion rightCurlyBracketRegion = this.textRegionExtensions.regionFor((EObject)expr).keyword(rightCurlyBracket);
        Procedures.Procedure1 _function_2 = it -> {
            if (this.comesAfter(rightCurlyBracketRegion, "}") || this.comesAfter(rightCurlyBracketRegion, ",") && this.comesAfter(rightCurlyBracketRegion.getPreviousSemanticRegion(), "}")) {
                it.noSpace();
            } else {
                it.newLine();
            }
        };
        document.prepend(rightCurlyBracketRegion, _function_2);
        Consumer<ISemanticRegion> _function_3 = valueExpr -> {
            Procedures.Procedure1 _function_4 = it -> it.noSpace();
            document.prepend(valueExpr, _function_4);
            String _text = valueExpr.getNextSemanticRegion().getText();
            boolean _equals = Objects.equals(_text, "}");
            if (_equals) {
                Procedures.Procedure1 _function_5 = it -> it.noSpace();
                document.append(valueExpr, _function_5);
            } else {
                Procedures.Procedure1 _function_6 = it -> it.newLine();
                document.append(valueExpr, _function_6);
            }
        };
        this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function_3);
        if (expr instanceof RosettaConstructorExpression) {
            Consumer<ConstructorKeyValuePair> _function_4 = it -> {
                Procedures.Procedure1 _function_5 = it_1 -> it_1.noSpace();
                Procedures.Procedure1 _function_6 = it_1 -> it_1.oneSpace();
                document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(":"), _function_5), _function_6);
                this.formatExpression(it.getValue(), document, mode);
            };
            ((RosettaConstructorExpression)expr).getValues().forEach(_function_4);
        }
        if (expr instanceof WithMetaOperation) {
            Consumer<WithMetaEntry> _function_5 = it -> {
                Procedures.Procedure1 _function_6 = it_1 -> it_1.noSpace();
                Procedures.Procedure1 _function_7 = it_1 -> it_1.oneSpace();
                document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(":"), _function_6), _function_7);
                this.formatExpression(it.getValue(), document, mode);
            };
            ((WithMetaOperation)expr).getEntries().forEach(_function_5);
        }
    }

    public boolean comesAfter(ISemanticRegion region, String el) {
        boolean _xifexpression = false;
        if (region != null && region.getPreviousSemanticRegion() != null) {
            boolean _xblockexpression = false;
            String prevRegionElement = region.getPreviousSemanticRegion().getText();
            _xifexpression = _xblockexpression = Objects.equals(prevRegionElement, el);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    public boolean comesBefore(ISemanticRegion region, String el) {
        boolean _xifexpression = false;
        if (region != null && region.getNextSemanticRegion() != null) {
            boolean _xblockexpression = false;
            String nextRegionElement = region.getNextSemanticRegion().getText();
            _xifexpression = _xblockexpression = Objects.equals(nextRegionElement, el);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    private ISemanticRegion findInnermostClosingCurlyBracket(ISemanticRegion region) {
        ISemanticRegion _xifexpression = null;
        boolean _comesAfter = this.comesAfter(region, "}");
        if (_comesAfter) {
            ISemanticRegion _xblockexpression = null;
            ISemanticRegion prevRegion = region.getPreviousSemanticRegion();
            _xifexpression = _xblockexpression = this.findInnermostClosingCurlyBracket(prevRegion);
        } else {
            ISemanticRegion _xifexpression_1 = null;
            if (this.comesAfter(region, ",") && this.comesAfter(region.getPreviousSemanticRegion(), "}")) {
                ISemanticRegion _xblockexpression_1 = null;
                ISemanticRegion prevRegion = region.getPreviousSemanticRegion().getPreviousSemanticRegion();
                _xifexpression_1 = _xblockexpression_1 = this.findInnermostClosingCurlyBracket(prevRegion);
            } else {
                _xifexpression_1 = region;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private boolean shouldBracketNotBeIndented(ISemanticRegion region) {
        return Objects.equals(region.getText(), "}") && (this.comesAfter(region, "}") || this.comesBefore(region, "}")) || this.comesAfter(region, ",") && this.comesAfter(region.getPreviousSemanticRegion(), "}") || this.comesBefore(region, ",") && this.comesBefore(region.getNextSemanticRegion(), "}");
    }

    public void indentInnerWithoutCurlyBracket(EObject expr, @Extension IFormattableDocument document) {
        IHiddenRegion ext = this._formattingUtil.getTextRegionExt(document).previousHiddenRegion(expr);
        this.indentInnerWithoutCurlyBracket(expr, ext.getNextHiddenRegion(), document);
    }

    public void indentInnerWithoutCurlyBracket(EObject expr, IHiddenRegion firstRegion, @Extension IFormattableDocument document) {
        if (expr == null || firstRegion == null) {
            return;
        }
        IHiddenRegion nextRegion = this._formattingUtil.getTextRegionExt(document).nextHiddenRegion(expr);
        ISemanticRegion end = nextRegion.getPreviousSemanticRegion();
        IHiddenRegion _xifexpression = null;
        boolean _shouldBracketNotBeIndented = this.shouldBracketNotBeIndented(end);
        _xifexpression = _shouldBracketNotBeIndented ? this.findInnermostClosingCurlyBracket(end).getPreviousHiddenRegion() : end.getNextHiddenRegion();
        Procedures.Procedure1 _function = it -> it.indent();
        document.set(firstRegion, _xifexpression, _function);
    }

    private void surroundIndentWithoutCurlyBracket(EObject expr, @Extension IFormattableDocument document) {
        if (expr == null) {
            return;
        }
        IEObjectRegion objectRegion = this.textRegionExtensions.regionForEObject(expr);
        ISemanticRegion end = objectRegion.getNextHiddenRegion().getPreviousSemanticRegion();
        IHiddenRegion _previousHiddenRegion = objectRegion.getPreviousHiddenRegion();
        IHiddenRegion _xifexpression = null;
        boolean _shouldBracketNotBeIndented = this.shouldBracketNotBeIndented(end);
        _xifexpression = _shouldBracketNotBeIndented ? this.findInnermostClosingCurlyBracket(end).getPreviousHiddenRegion() : end.getNextHiddenRegion();
        Procedures.Procedure1 _function = it -> it.indent();
        document.set(_previousHiddenRegion, _xifexpression, _function);
    }

    private void interiorIndentWithoutCurlyBracket(ISemanticRegion start, ISemanticRegion end, @Extension IFormattableDocument document) {
        if (start != null && end != null) {
            IHiddenRegion _nextHiddenRegion = start.getNextHiddenRegion();
            IHiddenRegion _xifexpression = null;
            boolean _shouldBracketNotBeIndented = this.shouldBracketNotBeIndented(end);
            _xifexpression = _shouldBracketNotBeIndented ? this.findInnermostClosingCurlyBracket(end).getPreviousHiddenRegion() : end.getPreviousHiddenRegion();
            Procedures.Procedure1 _function = it -> it.indent();
            document.set(_nextHiddenRegion, _xifexpression, _function);
        }
    }

    private void _unsafeFormatExpression(ListLiteral expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
            document.prepend(it, _function_1);
        };
        this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function);
        this.interiorIndentWithoutCurlyBracket(this.textRegionExtensions.regionFor((EObject)expr).keyword("["), this.textRegionExtensions.regionFor((EObject)expr).keyword("]"), document);
        Consumer<IFormattableDocument> _function_1 = doc -> {
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            doc.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("["), _function_2);
            Procedures.Procedure1 _function_3 = it -> it.noSpace();
            doc.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword("]"), _function_3);
            Consumer<ISemanticRegion> _function_4 = it -> {
                Procedures.Procedure1 _function_5 = it_1 -> it_1.oneSpace();
                doc.append(it, _function_5);
            };
            this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function_4);
            Consumer<RosettaExpression> _function_5 = it -> this.formatExpression((RosettaExpression)it, (IFormattableDocument)doc, mode);
            expr.getElements().forEach(_function_5);
        };
        Consumer<IFormattableDocument> _function_2 = doc -> {
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            doc.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("["), _function_3);
            Procedures.Procedure1 _function_4 = it -> it.newLine();
            doc.append((EObject)((RosettaExpression)IterableExtensions.lastOrNull(expr.getElements())), _function_4);
            Consumer<ISemanticRegion> _function_5 = it -> {
                Procedures.Procedure1 _function_6 = it_1 -> it_1.newLine();
                doc.append(it, _function_6);
            };
            this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function_5);
            Consumer<RosettaExpression> _function_6 = it -> this.formatExpression((RosettaExpression)it, (IFormattableDocument)doc, mode.stopChain());
            expr.getElements().forEach(_function_6);
        };
        this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function_1, _function_2);
    }

    private void _unsafeFormatExpression(RosettaConditionalExpression expr, @Extension IFormattableDocument document, FormattingMode mode) {
        RosettaGrammarAccess.RosettaCalcConditionalExpressionElements conditionalGrammarAccess = this._rosettaGrammarAccess.getRosettaCalcConditionalExpressionAccess();
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof ConstructorKeyValuePair) {
            Procedures.Procedure1 _function = it -> it.indent();
            document.surround(this.textRegionExtensions.regionFor((EObject)expr).keyword(conditionalGrammarAccess.getThenKeyword_3()), _function);
        }
        Consumer<ISemanticRegion> _function_1 = it -> {
            Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
            document.append(it, _function_2);
        };
        this.textRegionExtensions.regionFor((EObject)expr).keywords(new Keyword[]{conditionalGrammarAccess.getIfKeyword_1(), conditionalGrammarAccess.getThenKeyword_3(), conditionalGrammarAccess.getFullElseKeyword_5_0_0()}).forEach(_function_1);
        RosettaExpression _if = expr.getIf();
        RosettaExpression _ifthen = expr.getIfthen();
        RosettaExpression _elsethen = expr.getElsethen();
        List subExprs = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RosettaExpression[]{_if, _ifthen, _elsethen}));
        RosettaExpression _if_1 = expr.getIf();
        RosettaExpression _ifthen_1 = expr.getIfthen();
        Consumer<RosettaExpression> _function_2 = it -> {
            if (!(it instanceof RosettaUnaryOperation)) {
                this.surroundIndentWithoutCurlyBracket((EObject)it, document);
            }
        };
        Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RosettaExpression[]{_if_1, _ifthen_1})).forEach(_function_2);
        Consumer<IFormattableDocument> _function_3 = doc -> {
            Procedures.Procedure1 _function_4 = it -> it.oneSpace();
            doc.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(conditionalGrammarAccess.getThenKeyword_3()), _function_4);
            Procedures.Procedure1 _function_5 = it -> it.oneSpace();
            doc.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(conditionalGrammarAccess.getFullElseKeyword_5_0_0()), _function_5);
            Consumer<RosettaExpression> _function_6 = it -> this.formatExpression((RosettaExpression)it, (IFormattableDocument)doc, mode);
            subExprs.forEach(_function_6);
        };
        Consumer<IFormattableDocument> _function_4 = doc -> {
            Procedures.Procedure1 _function_5 = it -> it.newLine();
            doc.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(conditionalGrammarAccess.getThenKeyword_3()), _function_5);
            Procedures.Procedure1 _function_6 = it -> it.newLine();
            doc.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(conditionalGrammarAccess.getFullElseKeyword_5_0_0()), _function_6);
            EStructuralFeature _eContainingFeature = expr.eContainingFeature();
            boolean _equals = Objects.equals(_eContainingFeature, ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT);
            if (_equals) {
                this.indentInnerWithoutCurlyBracket(expr, (IFormattableDocument)doc);
            }
            this.formatExpression(expr.getIf(), (IFormattableDocument)doc, mode.stopChain());
            this.formatExpression(expr.getIfthen(), (IFormattableDocument)doc, mode.stopChain());
            RosettaExpression _elsethen_1 = expr.getElsethen();
            this.formatExpression(expr.getElsethen(), (IFormattableDocument)doc, mode.chainIf(_elsethen_1 instanceof RosettaConditionalExpression));
        };
        this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), (Integer)this._formattingUtil.getPreference(document, RosettaFormatterPreferenceKeys.conditionalMaxLineWidth), _function_3, _function_4);
    }

    private void _unsafeFormatExpression(RosettaFeatureCall expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)expr).keyword("->"), _function);
        this.formatExpression(expr.getReceiver(), document, mode.stopChain());
    }

    private void _unsafeFormatExpression(RosettaDeepFeatureCall expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)expr).keyword("->>"), _function);
        this.formatExpression(expr.getReceiver(), document, mode.stopChain());
    }

    private void _unsafeFormatExpression(RosettaLiteral expr, @Extension IFormattableDocument document, FormattingMode mode) {
    }

    private void _unsafeFormatExpression(RosettaOnlyExistsExpression expr, @Extension IFormattableDocument document, FormattingMode mode) {
        RosettaGrammarAccess.RosettaCalcOnlyExistsElements onlyExistsGrammarAccess = this._rosettaGrammarAccess.getRosettaCalcOnlyExistsAccess();
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("("), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(")"), _function_1);
        Consumer<ISemanticRegion> _function_2 = it -> {
            Procedures.Procedure1 _function_3 = it_1 -> it_1.noSpace();
            document.prepend(it, _function_3);
            Procedures.Procedure1 _function_4 = it_1 -> it_1.oneSpace();
            document.append(it, _function_4);
        };
        this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(onlyExistsGrammarAccess.getOnlyKeyword_2()), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(onlyExistsGrammarAccess.getExistsKeyword_3()), _function_4);
        Consumer<RosettaExpression> _function_5 = it -> this.formatExpression((RosettaExpression)it, document, mode.stopChain());
        expr.getArgs().forEach(_function_5);
    }

    private void _unsafeFormatExpression(RosettaImplicitVariable expr, @Extension IFormattableDocument document, FormattingMode mode) {
    }

    private void _unsafeFormatExpression(RosettaSymbolReference expr, @Extension IFormattableDocument document, FormattingMode mode) {
        RosettaGrammarAccess.RosettaReferenceOrFunctionCallElements referenceCallGrammarAccess = this._rosettaGrammarAccess.getRosettaReferenceOrFunctionCallAccess();
        boolean _isExplicitArguments = expr.isExplicitArguments();
        if (_isExplicitArguments) {
            Consumer<ISemanticRegion> _function = it -> {
                Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
                document.prepend(it, _function_1);
            };
            this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function);
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            document.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(referenceCallGrammarAccess.getExplicitArgumentsLeftParenthesisKeyword_0_2_0_0()), _function_1);
            Consumer<IFormattableDocument> _function_2 = doc -> {
                Procedures.Procedure1 _function_3 = it -> it.noSpace();
                doc.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("("), _function_3);
                Procedures.Procedure1 _function_4 = it -> it.noSpace();
                doc.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(")"), _function_4);
                Consumer<ISemanticRegion> _function_5 = it -> {
                    Procedures.Procedure1 _function_6 = it_1 -> it_1.oneSpace();
                    doc.append(it, _function_6);
                };
                this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function_5);
                Consumer<RosettaExpression> _function_6 = it -> this.formatExpression((RosettaExpression)it, (IFormattableDocument)doc, mode);
                expr.getArgs().forEach(_function_6);
            };
            Consumer<IFormattableDocument> _function_3 = doc -> {
                this.indentInnerWithoutCurlyBracket(expr, (IFormattableDocument)doc);
                Procedures.Procedure1 _function_4 = it -> it.newLine();
                Procedures.Procedure1 _function_5 = it -> it.newLine();
                this.interiorIndentWithoutCurlyBracket(doc.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("("), _function_4), doc.prepend(this.textRegionExtensions.regionFor((EObject)expr).keyword(")"), _function_5), (IFormattableDocument)doc);
                Consumer<ISemanticRegion> _function_6 = it -> {
                    Procedures.Procedure1 _function_7 = it_1 -> it_1.newLine();
                    doc.append(it, _function_7);
                };
                this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function_6);
                Consumer<RosettaExpression> _function_7 = it -> this.formatExpression((RosettaExpression)it, (IFormattableDocument)doc, mode.stopChain());
                expr.getArgs().forEach(_function_7);
            };
            this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function_2, _function_3);
        }
    }

    private void _unsafeFormatExpression(ModifiableBinaryOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        this.formatBinaryOperation(expr, document, mode);
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)expr).feature((EStructuralFeature)ExpressionPackage.Literals.MODIFIABLE_BINARY_OPERATION__CARD_MOD), _function);
    }

    private void _unsafeFormatExpression(RosettaBinaryOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        this.formatBinaryOperation(expr, document, mode);
    }

    private void formatBinaryOperation(RosettaBinaryOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)expr).feature((EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR), _function);
        Consumer<IFormattableDocument> _function_1 = doc -> {
            boolean _not;
            boolean _isEmpty = this.isEmpty(expr.getLeft());
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Procedures.Procedure1 _function_2 = it -> it.oneSpace();
                doc.set(this.textRegionExtensions.nextHiddenRegion((EObject)expr.getLeft()), _function_2);
                this.formatExpression(expr.getLeft(), (IFormattableDocument)doc, mode);
            }
            this.formatExpression(expr.getRight(), (IFormattableDocument)doc, mode);
        };
        Consumer<IFormattableDocument> _function_2 = doc -> {
            boolean _not;
            boolean _isEmpty = this.isEmpty(expr.getLeft());
            boolean bl = _not = !_isEmpty;
            if (_not) {
                IHiddenRegion afterArgument = this.textRegionExtensions.nextHiddenRegion((EObject)expr.getLeft());
                this.indentInnerWithoutCurlyBracket(expr, afterArgument, (IFormattableDocument)doc);
                Procedures.Procedure1 _function_3 = it -> it.newLine();
                doc.set(afterArgument, _function_3);
                boolean _xifexpression = false;
                RosettaExpression _left = expr.getLeft();
                if (_left instanceof RosettaBinaryOperation) {
                    String _operator = expr.getOperator();
                    RosettaExpression _left_1 = expr.getLeft();
                    String _operator_1 = ((RosettaBinaryOperation)_left_1).getOperator();
                    _xifexpression = Objects.equals(_operator, _operator_1);
                } else {
                    _xifexpression = false;
                }
                boolean leftIsSameOperation = _xifexpression;
                if (expr.getLeft() instanceof RosettaBinaryOperation && !leftIsSameOperation) {
                    this.indentInnerWithoutCurlyBracket(expr.getLeft(), (IFormattableDocument)doc);
                }
                this.formatExpression(expr.getLeft(), (IFormattableDocument)doc, mode.chainIf(leftIsSameOperation));
            }
            this.formatExpression(expr.getRight(), (IFormattableDocument)doc, mode.stopChain());
        };
        this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function_1, _function_2);
    }

    private void _unsafeFormatExpression(RosettaFunctionalOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = doc -> {
            boolean _tripleNotEquals;
            InlineFunction _function_1 = expr.getFunction();
            boolean bl = _tripleNotEquals = _function_1 != null;
            if (_tripleNotEquals) {
                this.formatInlineFunction(expr.getFunction(), (IFormattableDocument)doc, mode.stopChain());
            }
        };
        this.formatUnaryOperation(expr, document, mode, (Procedures.Procedure1<? super IFormattableDocument>)_function);
    }

    private void formatInlineFunction(InlineFunction f, @Extension IFormattableDocument document, FormattingMode mode) {
        EObject _eContainer = f.eContainer();
        RosettaFunctionalOperation op = (RosettaFunctionalOperation)_eContainer;
        ISemanticRegion left = this.textRegionExtensions.regionFor((EObject)f).keyword("[");
        if (left != null) {
            ISemanticRegion right = this.textRegionExtensions.regionFor((EObject)f).keyword("]");
            Consumer<ClosureParameter> _function = it -> {
                Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
                document.prepend((EObject)it, _function_1);
            };
            f.getParameters().forEach(_function);
            Procedures.Procedure1 _function_1 = it -> it.oneSpace();
            document.prepend(left, _function_1);
            Consumer<ISemanticRegion> _function_2 = it -> {
                Procedures.Procedure1 _function_3 = it_1 -> it_1.noSpace();
                document.prepend(it, _function_3);
            };
            this.textRegionExtensions.regionFor((EObject)f).keywords(new String[]{","}).forEach(_function_2);
            Consumer<IFormattableDocument> _function_3 = doc -> {
                Procedures.Procedure1 _function_4 = it -> it.oneSpace();
                doc.append(left, _function_4);
                Procedures.Procedure1 _function_5 = it -> it.oneSpace();
                doc.prepend(right, _function_5);
                this.formatExpression(f.getBody(), (IFormattableDocument)doc, mode);
                EObject _eContainer_1 = op.eContainer();
                if (_eContainer_1 instanceof RosettaOperation) {
                    Procedures.Procedure1 _function_6 = it -> {
                        it.highPriority();
                        it.newLine();
                    };
                    doc.append((EObject)f, _function_6);
                }
            };
            Consumer<IFormattableDocument> _function_4 = doc -> {
                Procedures.Procedure1 _function_5 = it -> it.newLine();
                Procedures.Procedure1 _function_6 = it -> it.newLine();
                this.interiorIndentWithoutCurlyBracket(doc.append(left, _function_5), doc.prepend(right, _function_6), (IFormattableDocument)doc);
                this.formatExpression(f.getBody(), (IFormattableDocument)doc, mode.stopChain());
            };
            this._formattingUtil.formatInlineOrMultiline(document, f, mode, _function_3, _function_4);
        } else {
            boolean _not;
            IEObjectRegion astRegion = this.textRegionExtensions.regionForEObject((EObject)f);
            ITextSegment formattableRegion = astRegion.merge((ITextRegion)astRegion.getPreviousHiddenRegion()).merge((ITextRegion)astRegion.getNextHiddenRegion());
            boolean bl = _not = !(op instanceof ThenOperation) || !(f.getBody() instanceof RosettaUnaryOperation);
            if (_not) {
                this.surroundIndentWithoutCurlyBracket(f.getBody(), document);
            }
            Consumer<IFormattableDocument> _function_5 = doc -> {
                Procedures.Procedure1 _function_6 = it -> it.oneSpace();
                this.formatExpression((RosettaExpression)doc.prepend((EObject)f.getBody(), _function_6), (IFormattableDocument)doc, mode);
                EObject _eContainer_1 = f.eContainer().eContainer();
                if (_eContainer_1 instanceof RosettaOperation) {
                    Procedures.Procedure1 _function_7 = it -> {
                        it.highPriority();
                        it.newLine();
                    };
                    doc.append((EObject)f, _function_7);
                }
            };
            Consumer<IFormattableDocument> _function_6 = doc -> {
                Procedures.Procedure1 _function_7 = it -> it.newLine();
                this.formatExpression((RosettaExpression)doc.prepend((EObject)f.getBody(), _function_7), (IFormattableDocument)doc, mode);
            };
            this._formattingUtil.formatInlineOrMultiline(document, (ITextSegment)astRegion, formattableRegion, mode.singleLineIf(op instanceof ThenOperation), _function_5, _function_6);
        }
    }

    private void _unsafeFormatExpression(SwitchOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        RosettaGrammarAccess.SwitchCaseOrDefaultElements switchCaseGrammarAccess = this._rosettaGrammarAccess.getSwitchCaseOrDefaultAccess();
        this._formattingUtil.indentInner(expr, document);
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
            document.prepend(it, _function_1);
        };
        this.textRegionExtensions.regionFor((EObject)expr).keywords(new String[]{","}).forEach(_function);
        Procedures.Procedure1 _function_1 = doc -> {
            Consumer<SwitchCaseOrDefault> _function_2 = switchCase -> {
                ISemanticRegion _keyword_1;
                this._formattingUtil.indentInner((EObject)switchCase, (IFormattableDocument)doc);
                Procedures.Procedure1 _function_3 = it -> it.newLine();
                doc.prepend((EObject)switchCase, _function_3);
                Procedures.Procedure1 _function_4 = it -> it.oneSpace();
                doc.prepend(this.textRegionExtensions.regionFor((EObject)switchCase).keyword(switchCaseGrammarAccess.getThenKeyword_1_1()), _function_4);
                ISemanticRegion _elvis = null;
                ISemanticRegion _keyword = this.textRegionExtensions.regionFor((EObject)switchCase).keyword(switchCaseGrammarAccess.getThenKeyword_1_1());
                _elvis = _keyword != null ? _keyword : (_keyword_1 = this.textRegionExtensions.regionFor((EObject)switchCase).keyword(switchCaseGrammarAccess.getDefaultKeyword_0_0()));
                ISemanticRegion thenOrDefault = _elvis;
                RosettaExpression caseExpression = switchCase.getExpression();
                Consumer<IFormattableDocument> _function_5 = nestedDoc -> {
                    Procedures.Procedure1 _function_6 = it -> it.oneSpace();
                    nestedDoc.append(thenOrDefault, _function_6);
                    this.formatExpression(caseExpression, (IFormattableDocument)nestedDoc, mode);
                };
                Consumer<IFormattableDocument> _function_6 = nestedDoc -> {
                    Procedures.Procedure1 _function_7 = it -> it.newLine();
                    nestedDoc.append(thenOrDefault, _function_7);
                    this.formatExpression(caseExpression, (IFormattableDocument)nestedDoc, mode);
                };
                this._formattingUtil.formatInlineOrMultiline(document, (EObject)switchCase, mode.singleLineIf(this.shouldBeOnSingleLine(caseExpression)), (Integer)this._formattingUtil.getPreference((IFormattableDocument)doc, RosettaFormatterPreferenceKeys.conditionalMaxLineWidth), _function_5, _function_6);
            };
            expr.getCases().forEach(_function_2);
        };
        this.formatUnaryOperation(expr, document, mode, (Procedures.Procedure1<? super IFormattableDocument>)_function_1);
    }

    private void _unsafeFormatExpression(RosettaExistsExpression expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = it -> {};
        this.formatUnaryOperation(expr, document, mode, (Procedures.Procedure1<? super IFormattableDocument>)_function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)expr).feature((EStructuralFeature)ExpressionPackage.Literals.ROSETTA_EXISTS_EXPRESSION__MODIFIER), _function_1);
    }

    private void _unsafeFormatExpression(ChoiceOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = it -> {};
        this.formatUnaryOperation(expr, document, mode, (Procedures.Procedure1<? super IFormattableDocument>)_function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)expr).feature((EStructuralFeature)ExpressionPackage.Literals.ROSETTA_OPERATION__OPERATOR), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.allRegionsFor((EObject)expr).keyword(","), _function_2), _function_3);
    }

    private void _unsafeFormatExpression(RosettaAbsentExpression expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = it -> {};
        this.formatUnaryOperation(expr, document, mode, (Procedures.Procedure1<? super IFormattableDocument>)_function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)expr).keyword("is"), _function_1);
    }

    private void _unsafeFormatExpression(RosettaUnaryOperation expr, @Extension IFormattableDocument document, FormattingMode mode) {
        Procedures.Procedure1 _function = it -> {};
        this.formatUnaryOperation(expr, document, mode, (Procedures.Procedure1<? super IFormattableDocument>)_function);
    }

    private void formatUnaryOperation(RosettaUnaryOperation expr, @Extension IFormattableDocument document, FormattingMode mode, Procedures.Procedure1<? super IFormattableDocument> internalFormatter) {
        Consumer<IFormattableDocument> _function = doc -> {
            boolean _not;
            boolean _isEmpty = this.isEmpty(expr.getArgument());
            boolean bl = _not = !_isEmpty;
            if (_not) {
                IHiddenRegion afterArgument = this.textRegionExtensions.nextHiddenRegion((EObject)expr.getArgument());
                Procedures.Procedure1 _function_1 = it -> it.oneSpace();
                doc.set(afterArgument, _function_1);
                this.formatExpression(expr.getArgument(), (IFormattableDocument)doc, mode);
            }
            internalFormatter.apply(doc);
        };
        Consumer<IFormattableDocument> _function_1 = doc -> {
            boolean _not;
            boolean _isEmpty = this.isEmpty(expr.getArgument());
            boolean bl = _not = !_isEmpty;
            if (_not) {
                boolean _not_1;
                IHiddenRegion afterArgument = this.textRegionExtensions.nextHiddenRegion((EObject)expr.getArgument());
                RosettaExpression initialArgument = expr.getArgument();
                while (initialArgument instanceof RosettaUnaryOperation) {
                    initialArgument = ((RosettaUnaryOperation)initialArgument).getArgument();
                }
                boolean _isEmpty_1 = this.isEmpty(initialArgument);
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    this.indentInnerWithoutCurlyBracket(expr, afterArgument, (IFormattableDocument)doc);
                }
                Procedures.Procedure1 _function_2 = it -> it.newLine();
                doc.set(afterArgument, _function_2);
                RosettaExpression _argument = expr.getArgument();
                this.formatExpression(expr.getArgument(), (IFormattableDocument)doc, mode.chainIf(_argument instanceof RosettaUnaryOperation));
            }
            internalFormatter.apply(doc);
        };
        this._formattingUtil.formatInlineOrMultiline(document, expr, mode.singleLineIf(this.shouldBeOnSingleLine(expr)), _function, _function_1);
    }

    @XbaseGenerated
    private void unsafeFormatExpression(RosettaExpression expr, IFormattableDocument document, FormattingMode mode) {
        if (expr instanceof ChoiceOperation) {
            this._unsafeFormatExpression((ChoiceOperation)expr, document, mode);
            return;
        }
        if (expr instanceof ModifiableBinaryOperation) {
            this._unsafeFormatExpression((ModifiableBinaryOperation)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaAbsentExpression) {
            this._unsafeFormatExpression((RosettaAbsentExpression)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaExistsExpression) {
            this._unsafeFormatExpression((RosettaExistsExpression)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaFunctionalOperation) {
            this._unsafeFormatExpression((RosettaFunctionalOperation)expr, document, mode);
            return;
        }
        if (expr instanceof SwitchOperation) {
            this._unsafeFormatExpression((SwitchOperation)expr, document, mode);
            return;
        }
        if (expr instanceof WithMetaOperation) {
            this._unsafeFormatExpression((WithMetaOperation)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaBinaryOperation) {
            this._unsafeFormatExpression((RosettaBinaryOperation)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaImplicitVariable) {
            this._unsafeFormatExpression((RosettaImplicitVariable)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaLiteral) {
            this._unsafeFormatExpression((RosettaLiteral)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaSymbolReference) {
            this._unsafeFormatExpression((RosettaSymbolReference)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaUnaryOperation) {
            this._unsafeFormatExpression((RosettaUnaryOperation)expr, document, mode);
            return;
        }
        if (expr instanceof ListLiteral) {
            this._unsafeFormatExpression((ListLiteral)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaConditionalExpression) {
            this._unsafeFormatExpression((RosettaConditionalExpression)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaConstructorExpression) {
            this._unsafeFormatExpression((RosettaConstructorExpression)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaDeepFeatureCall) {
            this._unsafeFormatExpression((RosettaDeepFeatureCall)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaFeatureCall) {
            this._unsafeFormatExpression((RosettaFeatureCall)expr, document, mode);
            return;
        }
        if (expr instanceof RosettaOnlyExistsExpression) {
            this._unsafeFormatExpression((RosettaOnlyExistsExpression)expr, document, mode);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{expr, document, mode}).toString());
    }
}

